//
//  SMShowTextView.m
//  SkinMagnifier
//
//  Created by nana on 2020/11/26.
//

#import "SMShowTextView.h"

@interface SMShowTextView()

@property(nonatomic ,strong)UILabel *textLabel;
@property(nonatomic ,strong)UIView  *contView;

@end

@implementation SMShowTextView


- (void)showFromView:(UIView *)view text:(NSString *)text afterDelay:(CGFloat )afterDelay {

    CGFloat tW = view.bounds.size.width- 100;
   CGRect tRect =  [text boundingRectWithSize:CGSizeMake(tW, MAXFLOAT)
                                         options:NSStringDrawingUsesFontLeading|NSStringDrawingUsesLineFragmentOrigin|NSStringDrawingTruncatesLastVisibleLine
                                      attributes:@{NSFontAttributeName:[UIFont systemFontOfSize:15]}
                                         context:nil];
    
    UIView *contView = [[UIView alloc] init];
    contView.backgroundColor = rgba(51, 51, 51,0.3);
    contView.layer.cornerRadius = 10;
    contView.layer.masksToBounds= YES;
    contView.frame = CGRectMake(50, 100,tW +40, tRect.size.height+40);
    [view addSubview:contView];
    
    UILabel *textLabel = [[UILabel alloc] init];
    textLabel.numberOfLines = 0;
    textLabel.attributedText = createAttString(text, 15, [UIColor whiteColor]);
    textLabel.frame = CGRectMake(20, 20, tW, tRect.size.height);
    [contView addSubview:textLabel];
    
    dispatch_after(dispatch_time(DISPATCH_TIME_NOW, (int64_t)(afterDelay * NSEC_PER_SEC)), dispatch_get_main_queue(), ^{
        [contView removeFromSuperview];
    });

}
@end
