//
//  SMYZMView.m
//  SkinMagnifier
//
//  Created by nana on 2020/12/10.
//

#import "SMYZMView.h"

@interface SMYZMView()
@property(nonatomic,strong)UITextField *inputTF;
@property(nonatomic,strong)NSMutableArray *btnArray;
@property(nonatomic,strong)UIImageView *gbImageView;
@end

@implementation SMYZMView

- (instancetype)init
{
    self = [super init];
    if (self) {
        [self setupUI];
    }
    return self;
}
- (void)setupUI {
    self.inputTF = [[UITextField alloc] init];
    [self.inputTF addTarget:self action:@selector(tfTextChange:) forControlEvents:UIControlEventEditingChanged];
    [self.inputTF addTarget:self action:@selector(tfTextEnd:) forControlEvents:UIControlEventEditingDidEnd];
    self.inputTF.textColor = [UIColor clearColor];
    self.inputTF.tintColor = [UIColor clearColor];
    [self addSubview:self.inputTF];
    [self.inputTF mas_makeConstraints:^(MASConstraintMaker *make) {
        make.top.left.mas_equalTo(0);
        make.size.mas_equalTo(CGSizeMake(2, 2));
    }];


    
    self.btnArray = [[NSMutableArray alloc] init];
    for (int i = 0; i < 4; i++) {
        UIButton *oneBtn = [[UIButton alloc] init];
        [oneBtn addTarget:self action:@selector(btnClick:) forControlEvents:UIControlEventTouchUpInside];
        oneBtn.backgroundColor = rgba(241, 241, 241, 1);
        oneBtn.layer.cornerRadius = 10;
        [self addSubview:oneBtn];
        [oneBtn mas_makeConstraints:^(MASConstraintMaker *make) {
            make.left.mas_equalTo(i*(57+19));
            make.centerY.mas_equalTo(0);
            make.size.mas_equalTo(CGSizeMake(57, 57));
        }];
        [self.btnArray addObject:oneBtn];
    }
    
    NSMutableArray *imgArray = [[NSMutableArray alloc] init];
    for (int i = 0; i < 10; i++) {
        UIImage *img2 = [UIImage wb_imageWithColor:rgba(0, 0, 255, i/10.0) size:CGSizeMake(2, 20)];
        [imgArray addObject:img2];
        
        UIImage *img1 = [UIImage wb_imageWithColor:rgba(0, 0, 255, i/10.0) size:CGSizeMake(2, 20)];
        [imgArray addObject:img1];
    }
    for (int i = 0; i < 10; i++) {
        UIImage *img2 = [UIImage wb_imageWithColor:rgba(0, 0, 255, (10-i)/10.0) size:CGSizeMake(2, 20)];
        [imgArray addObject:img2];
        UIImage *img1 = [UIImage wb_imageWithColor:rgba(0, 0, 255, (10-i)/10.0) size:CGSizeMake(2, 20)];
        [imgArray addObject:img1];
    }
    
    self.gbImageView = [[UIImageView alloc] init];
    self.gbImageView.animationImages = imgArray;
    [self.gbImageView startAnimating];
    [self addSubview:self.gbImageView];
}

- (void)tfTextEnd:(UITextField *)tf {
    self.gbImageView.hidden = YES;
}
- (void)btnClick:(UIButton *)btn {
    [self.inputTF becomeFirstResponder];
    self.inputTF.text = @"";
    [self tfTextChange:self.inputTF];
}

- (void)tfTextChange:(UITextField *)tf {

    
    for (int i = 0; i < self.btnArray.count; i++) {
        UIButton *btn = self.btnArray[i];
        if (tf.text.length > i) {
            NSString *tString = [tf.text substringWithRange:NSMakeRange(i, 1)];
            [btn setAttributedTitle:createAttString(tString, 25, rgba(51, 51, 51, 1)) forState:UIControlStateNormal];
        }else {
            [btn setAttributedTitle:createAttString(@"", 25, rgba(51, 51, 51, 1)) forState:UIControlStateNormal];
        }
    }
    if (tf.text.length < self.btnArray.count) {
        UIButton *lastBtn = self.btnArray[tf.text.length];
        self.gbImageView.hidden = NO;
        [self.gbImageView mas_remakeConstraints:^(MASConstraintMaker *make) {
            make.center.equalTo(lastBtn);
        }];
    }else {
        self.gbImageView.hidden = YES;
        if (self.editBlock) {
            self.editBlock(tf.text);
        }

        tf.text = @"";
        [self tfTextChange:tf];
    }

}

@end
