//
//  SMAIImageTool.m
//  SkinMagnifier
//
//  Created by nana on 2021/1/7.
//

#import "SMAIImageTool.h"
#import "brown.h"
#import "roughPore.h"
#import "wrinkle.h"
#import "BlockedPore.h"
#import <opencv2/imgcodecs/ios.h>
#define pi (3.141592654)
@implementation SMAIImageTool


//皮脂hhsas
float hormone_process(cv::Mat image, cv::Mat map)
{
    float ss = 0;
    float ratio = 0;
    float s = image.cols * image.rows;

    cv::Mat gray;
    // 获取原图的灰度图
    cv::cvtColor(image, gray, COLOR_BGR2GRAY);
    // 获取伪色卡图
    cv::applyColorMap(gray, map, COLORMAP_COOL);
   // cv::imwrite("./1.jpg", map);
    // 获取伪色卡的灰度图
    cv::cvtColor(map, gray, COLOR_BGR2GRAY);
    // 阈值分割
    cv::threshold(gray, gray, 127, 255, cv::THRESH_OTSU+cv::THRESH_BINARY_INV);
    cv::threshold(gray, gray, 134, 255, cv::THRESH_BINARY);
    cv::Mat kernel = cv::getStructuringElement(MORPH_RECT, cv::Size(3,3));
    // 膨胀操作
    cv::dilate(gray, gray, kernel, cv::Point(-1,-1), 1);
    //cv::imwrite("./2.jpg", gray);

    std::vector<std::vector<cv::Point> > contours;
    // 获取轮廓
    cv::findContours(gray, contours, cv::RETR_LIST, cv::CHAIN_APPROX_SIMPLE);

    //计算面积占比
    ss = cv::countNonZero(gray);
//    if (contours.size() > 0)
//    {
//        for (int i = 0; i < contours.size(); i++)
//        {
//            vector<cv::Point> c = contours[i];
//            float area = fabs(cv::contourArea(c));
//            ss = ss + area;
//        }
//    }
    ratio = ss / s * 100;

    cv::Mat mask = cv::Mat::zeros(gray.rows, gray.cols, image.type());

    cv::fillPoly(mask, contours, cv::Scalar(0, 255, 0));
   // cv::imwrite("./3.jpg", mask);

    // cout << mask.type() << endl;


    cv::addWeighted(image, 1.0, mask, 0.4, 0, map);
   // cv::imwrite("./hormone.jpg", map);
    return ratio;
}

//红区
float red_process(cv::Mat image, cv::Mat pink, cv::Mat map)
{

    float ss = 0;
    float ratio = 0;
    float s = image.cols * image.rows;

    cv::Mat pink_gray;
    // 获取原图的灰度图
    cv::cvtColor(pink, pink_gray, COLOR_BGR2GRAY);
    // 获取伪色卡图
    cv::applyColorMap(pink_gray, map, COLORMAP_RAINBOW);
    // cv::imwrite("./result1/2.jpg", map);
    cv::cvtColor(map, pink_gray, COLOR_BGR2HSV);

    cv::inRange(pink_gray, Scalar(11, 254, 254), Scalar(33, 255, 255), pink_gray);
    // cv::imwrite("./4.jpg", map);

    std::vector<std::vector<cv::Point> > contours;
    // 获取轮廓
    cv::findContours(pink_gray, contours, cv::RETR_LIST, cv::CHAIN_APPROX_SIMPLE);
    //计算面积占比
    ss = cv::countNonZero(pink_gray);
//    if (contours.size() > 0)
//    {
//        for (int i = 0; i < contours.size(); i++)
//        {
//            vector<cv::Point> c = contours[i];
//            float area = fabs(cv::contourArea(c));
//            ss = ss + area;
//        }
//    }
    ratio = ss / s * 100;

    cv::Mat mask = cv::Mat::zeros(pink_gray.rows, pink_gray.cols, image.type());

    cv::fillPoly(mask, contours, cv::Scalar(0, 0, 255));
    // cv::imwrite("./5.jpg", mask);

    // cout << mask.type() << endl;


    cv::addWeighted(image, 1.0, mask, 0.4, 0, map);
  //  cv::imwrite("./result/4.jpg", map);
    return ratio;
}

//色沉
float dull_process(cv::Mat image, cv::Mat brown, cv::Mat result)
{

    float ss = 0;
    float ratio = 0;
    float s = image.cols * image.rows;

    cv::Mat brown_gray;
    // 获取棕图的灰度图
    cv::cvtColor(brown, brown_gray, COLOR_BGR2GRAY);
    // 阈值分割
    cv::threshold(brown_gray, brown_gray, 70, 255, cv::THRESH_BINARY_INV);
   // cv::imwrite("./4.jpg", brown_gray);

    std::vector<std::vector<cv::Point> > contours;
    // 获取轮廓
    cv::findContours(brown_gray, contours, cv::RETR_LIST, cv::CHAIN_APPROX_SIMPLE);

    //计算面积占比
    ss = cv::countNonZero(brown_gray);
//    if (contours.size() > 0)
//    {
//        for (int i = 0; i < contours.size(); i++)
//        {
//            vector<cv::Point> c = contours[i];
//            float area = fabs(cv::contourArea(c));
//            ss = ss + area;
//        }
//    }
    ratio = ss / s * 100;

    cv::Mat mask = cv::Mat::zeros(brown_gray.rows, brown_gray.cols, image.type());
    cv::fillPoly(mask, contours, cv::Scalar(0, 255, 255));
    //cv::imwrite("./3.jpg", mask);

    cv::addWeighted(image, 1.0, mask, 0.4, 0, result);
    //cv::imwrite("./dull.jpg", result);
    return ratio;
}

int pink_image_processing( cv::Mat img, cv::Mat& pink_gray, cv::Mat& pink_image)
{
    int width, height;
    int y, cb, cr;
    double a = 0.82556;
    double c = -268;
    double d = 0;
    int length_p = 0;
    // double dtime = what_time_is_it_now();
    double p[] = {0.20141, 0.20654, 0.21182, 0.21723, 0.22279, 0.22849, 0.23435, 0.24036, 0.24652, 0.25284, 0.25933, 0.26598, 0.27279, 0.27978, 0.28694, 0.29427,
        0.30177, 0.30945, 0.31731, 0.32535, 0.33357, 0.34197, 0.35055, 0.35932, 0.36826, 0.37739, 0.38669, 0.39617, 0.40583, 0.41566, 0.42565, 0.43582,
        0.44614, 0.45662, 0.46726, 0.47804, 0.48895, 0.50000, 0.51117, 0.52246, 0.53385, 0.54534, 0.55691, 0.56856, 0.58027, 0.59203, 0.60383, 0.61565,
        0.62749, 0.63932, 0.65113, 0.66291, 0.67465, 0.68632, 0.69792, 0.70942, 0.72082, 0.73209, 0.74323, 0.75421, 0.76503, 0.77567, 0.78612, 0.79636,
        0.80639, 0.81618, 0.82574, 0.83505, 0.84410, 0.85289, 0.86141, 0.86965, 0.87760, 0.88527, 0.89265, 0.89973, 0.90653, 0.91303, 0.91923, 0.92515,
        0.93077, 0.93612, 0.94118, 0.94596, 0.95047, 0.95472, 0.95871, 0.96245, 0.96594, 0.96920, 0.97223, 0.97504, 0.97764, 0.98004, 0.98225, 0.98427,
        0.98612, 0.98780, 0.98933, 0.99072, 0.99197, 0.99308, 0.99408, 0.99497, 0.99575, 0.99644, 0.99704, 0.99757, 0.99802, 0.99840, 0.99873, 0.99900,
        0.99923, 0.99941, 0.99956, 0.99968, 0.99978, 0.99985, 0.99990, 0.99994, 0.99996, 0.99998, 0.99999, 1.00000, 1.00000, 1.00000, 1.00000, 1.00000};

        // const unsigned char pink_gray_r[256] = { 91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  95,  99,  99, 100, 100, 104, 110, 114, 115, 115, 120, 122, 126, 127, 130, 133, 134, 136, 138, 140, 140, 143, 144, 145, 147, 147, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 161, 162, 163, 164, 164, 166, 166, 167, 167, 169, 169, 170, 171, 172, 172, 173, 174, 174, 175, 175, 176, 177, 177, 178, 178, 179, 180, 181, 181, 182, 182, 183, 184, 184, 184, 186, 186, 186, 187, 188, 188, 189, 189, 190, 191, 191, 192, 192, 192, 193, 194, 194, 195, 195, 196, 197, 197, 197, 198, 198, 199, 200, 200, 200, 201, 202, 202, 203, 203, 203, 204, 205, 205, 205, 206, 206, 207, 207, 208, 208, 209, 209, 209, 210, 211, 211, 211, 212, 212, 213, 213, 214, 214, 215, 215, 215, 216, 217, 217, 217, 218, 218, 219, 219, 219, 220, 220, 221, 221, 222, 222, 223, 223, 223, 224, 224, 225, 225, 225, 226, 226, 227, 227, 228, 228, 228, 229, 229, 229, 230, 230, 231, 231, 231, 232, 233, 233, 233, 234, 234, 234, 235, 235, 236, 236, 236, 237, 237, 237, 238, 239, 239, 239, 240, 240, 240, 241, 241, 241, 242, 242, 242, 243, 243, 243, 244, 244, 245, 245, 245, 246, 246, 246, 247, 248, 248, 248, 248, 249, 250, 250, 250, 250, 251, 251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 254, 255};
        // const unsigned char pink_gray_g[256] = {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   8,   9,  10,  16,  18,  21,  25,  27,  29,  32,  34,  35,  38,  40,  43,  44,  47,  48,  51,  52,  54,  56,  57,  60,  61,  63,  65,  66,  67,  69,  71,  73,  74,  75,  78,  78,  80,  82,  83,  84,  85,  87,  88,  89,  91,  92,  93,  95,  97,  98, 100, 100, 102, 104, 105, 105, 107, 107, 109, 110, 111, 113, 114, 115, 117, 118, 119, 120, 122, 122, 123, 124, 126, 127, 128, 129, 131, 131, 132, 133, 135, 136, 137, 137, 139, 140, 141, 142, 144, 144, 145, 146, 148, 148, 149, 150, 151, 153, 153, 154, 155, 157, 157, 158, 159, 161, 161, 162, 163, 164, 166, 166, 167, 168, 170, 170, 171, 172, 173, 173, 175, 176, 177, 177, 179, 179, 180, 181, 183, 183, 184, 185, 186, 186, 188, 189, 189, 190, 192, 192, 193, 194, 195, 195, 197, 197, 198, 199, 199, 201, 202, 202, 203, 205, 205, 206, 207, 207, 208, 210, 210, 211, 212, 212, 214, 214, 215, 216, 217, 217, 219, 220, 220, 221, 222, 223, 223, 225, 225, 226, 227, 227, 228, 229, 230, 231, 232, 232, 233, 234, 235, 236, 236, 237, 238, 239, 239, 241, 241, 242, 243, 243, 245, 245, 246, 247, 247, 248, 249, 250, 250, 251, 252, 252, 254, 254, 255};
        // const unsigned char pink_gray_b[256] = {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   1,   4,  10,  15,  17,  21,  27,  28,  29,  34,  36,  39,  42,  44,  46,  49,  50,  52,  54,  56,  59,  60,  62,  64,  66,  67,  70,  71,  72,  74,  76,  78,  79,  80,  82,  83,  85,  86,  88,  89,  91,  91,  94,  95,  96,  97,  98, 100, 101, 102, 103, 104, 105, 107, 109, 110, 111, 111, 114, 115, 116, 116, 119, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129, 131, 132, 132, 133, 134, 135, 137, 138, 139, 140, 140, 141, 143, 144, 145, 146, 146, 147, 149, 150, 151, 152, 152, 153, 155, 156, 156, 157, 158, 159, 161, 161, 162, 163, 164, 164, 165, 166, 168, 168, 169, 170, 171, 172, 172, 174, 175, 176, 176, 177, 178, 180, 180, 181, 182, 183, 183, 184, 184, 186, 187, 188, 188, 189, 190, 192, 192, 193, 194, 194, 195, 196, 196, 198, 199, 200, 200, 201, 201, 202, 204, 204, 205, 206, 206, 207, 208, 208, 210, 211, 211, 212, 213, 213, 214, 216, 216, 217, 217, 218, 219, 220, 220, 222, 223, 223, 224, 224, 225, 225, 227, 227, 227, 229, 229, 230, 231, 232, 232, 233, 233, 235, 236, 236, 237, 237, 238, 239, 241, 241, 242, 242, 243, 244, 244, 245, 245, 247, 248, 248, 248, 249, 250, 250, 251, 253, 253, 254, 254, 255};

        const unsigned char pink_gray_r[256] = {91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  91,  95,  99,  99, 100, 100, 104,
                    110, 114, 115, 115, 120, 122, 126, 127, 130, 133, 134, 136, 138, 140, 140, 143, 144, 145, 147, 147, 149, 150, 151, 152, 153, 154, 155,
                    156, 157, 158, 159, 160, 161, 161, 162, 163, 164, 164, 166, 166, 167, 167, 169, 169, 170, 171, 172, 172, 173, 174, 174, 175, 175, 176,
                    177, 177, 178, 178, 179, 180, 181, 181, 182, 182, 183, 184, 184, 184, 186, 186, 186, 187, 188, 188, 189, 189, 190, 191, 191, 192, 192,
                    192, 193, 194, 194, 195, 195, 196, 197, 197, 197, 198, 198, 199, 200, 200, 200, 201, 202, 202, 203, 203, 203, 204, 205, 205, 205, 206,
                    206, 207, 207, 208, 208, 209, 209, 209, 210, 211, 211, 211, 212, 212, 213, 213, 214, 214, 215, 215, 215, 216, 217, 217, 217, 218, 218,
                    219, 219, 219, 220, 220, 221, 221, 222, 222, 223, 223, 223, 224, 224, 225, 225, 225, 226, 226, 227, 227, 228, 228, 228, 229, 229, 229,
                    230, 230, 231, 231, 231, 232, 233, 233, 233, 234, 234, 234, 235, 235, 236, 236, 236, 237, 237, 237, 238, 239, 239, 239, 240, 240, 240,
                    241, 241, 241, 242, 242, 242, 243, 243, 243, 244, 244, 245, 245, 245, 246, 246, 246, 247, 248, 248, 248, 248, 249, 250, 250, 250, 250,
                    251, 251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 254, 255};
        const unsigned char pink_gray_g[256] = {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,
                    0,   0,   0,   1,   1,   1,   1,   1,   1,   1,   1,   1,   8,   9,  10,  16,  18,  21,  25,  27,  29,  32,  34,  35,  38,  40,  43,
                    44,  47,  48,  51,  52,  54,  56,  57,  60,  61,  63,  65,  66,  67,  69,  71,  73,  74,  75,  78,  78,  80,  82,  83,  84,  85,  87,
                    88,  89,  91,  92,  93,  95,  97,  98, 100, 100, 102, 104, 105, 105, 107, 107, 109, 110, 111, 113, 114, 115, 117, 118, 119, 120, 122,
                    122, 123, 124, 126, 127, 128, 129, 131, 131, 132, 133, 135, 136, 137, 137, 139, 140, 141, 142, 144, 144, 145, 146, 148, 148, 149, 150,
                    151, 153, 153, 154, 155, 157, 157, 158, 159, 161, 161, 162, 163, 164, 166, 166, 167, 168, 170, 170, 171, 172, 173, 173, 175, 176, 177,
                    177, 179, 179, 180, 181, 183, 183, 184, 185, 186, 186, 188, 189, 189, 190, 192, 192, 193, 194, 195, 195, 197, 197, 198, 199, 199, 201,
                    202, 202, 203, 205, 205, 206, 207, 207, 208, 210, 210, 211, 212, 212, 214, 214, 215, 216, 217, 217, 219, 220, 220, 221, 222, 223, 223,
                    225, 225, 226, 227, 227, 228, 229, 230, 231, 232, 232, 233, 234, 235, 236, 236, 237, 238, 239, 239, 241, 241, 242, 243, 243, 245, 245,
                    246, 247, 247, 248, 249, 250, 250, 251, 252, 252, 254, 254, 255};
        const unsigned char pink_gray_b[256] = {0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   1,   1,   1,
                    1,   1,   1,   1,   1,   1,   1,   4,  10,  15,  17,  21,  27,  28,  29,  34,  36,  39,  42,  44,  46,  49,  50,  52,  54,  56,  59,
                    60,  62,  64,  66,  67,  70,  71,  72,  74,  76,  78,  79,  80,  82,  83,  85,  86,  88,  89,  91,  91,  94,  95,  96,  97,  98, 100,
                    101, 102, 103, 104, 105, 107, 109, 110, 111, 111, 114, 115, 116, 116, 119, 119, 120, 121, 122, 123, 125, 126, 127, 128, 129, 131, 132,
                    132, 133, 134, 135, 137, 138, 139, 140, 140, 141, 143, 144, 145, 146, 146, 147, 149, 150, 151, 152, 152, 153, 155, 156, 156, 157, 158,
                    159, 161, 161, 162, 163, 164, 164, 165, 166, 168, 168, 169, 170, 171, 172, 172, 174, 175, 176, 176, 177, 178, 180, 180, 181, 182, 183,
                    183, 184, 184, 186, 187, 188, 188, 189, 190, 192, 192, 193, 194, 194, 195, 196, 196, 198, 199, 200, 200, 201, 201, 202, 204, 204, 205,
                    206, 206, 207, 208, 208, 210, 211, 211, 212, 213, 213, 214, 216, 216, 217, 217, 218, 219, 220, 220, 222, 223, 223, 224, 224, 225, 225,
                    227, 227, 227, 229, 229, 230, 231, 232, 232, 233, 233, 235, 236, 236, 237, 237, 238, 239, 241, 241, 242, 242, 243, 244, 244, 245, 245,
                    247, 248, 248, 248, 249, 250, 250, 251, 253, 253, 254, 254, 255};

    length_p = sizeof(p) / sizeof(double);

    if (img.empty()) return -1;
    width = img.cols;
    height = img.rows;

    pink_gray =cv::Mat(img.size(), CV_8UC1);
    if (pink_gray.empty()) return -2;

    cv::Mat ycbcrimg;
    cvtColor(img, ycbcrimg, cv::COLOR_BGR2YCrCb);

    std::vector<cv::Mat> imgs;
    split(ycbcrimg, imgs);
    imgs[0] = imgs[0] + 16;
    merge(imgs, ycbcrimg);

    for (int i = 0; i < height; i++)
    {
        uchar* pgray = pink_gray.data + pink_gray.step * i;
        uchar* pycbcr = ycbcrimg.data + ycbcrimg.step * i;
        for (int j = 0; j < width; j++)
        {
            int gray;
            y =  pycbcr[0];
            cr = pycbcr[1];
            cb = pycbcr[2];

            if (y < length_p)
                d = 4.25 * (a * cb + cr + c) * p[y] - (1 - p[y]) * 170;
            else
                d = 4.25 * (a * cb + cr + c);

            if (d > 0)
                gray = 31;
            else
                gray = 0.0076 * d * d + 31;

            if (gray > 255) gray = 255;

            *pgray = gray;
            pgray++;
            pycbcr += 3;
        }
    }
    GaussianBlur(pink_gray, pink_gray, cv::Size(5,5), 1.6);

    cv::Mat pink_color(256, 1, CV_8UC3);
    for(int i = 0; i < 256; i++) {
        pink_color.at<cv::Vec3b>(i)[0] = pink_gray_b[i];
        pink_color.at<cv::Vec3b>(i)[1] = pink_gray_g[i];
        pink_color.at<cv::Vec3b>(i)[2] = pink_gray_r[i];
    }
    applyColorMap(pink_gray, pink_image, pink_color);
    // cv::imwrite("./33.jpg", pink_image);


    return 0;
}


+(NSDictionary *)haoKongCuDaWithJihuaImg:(UIImage *)jihuaImg {
    cv::Mat cvImage;
    UIImageToMat(jihuaImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);
    RoughPoreData resultData = detectRoughPore(cvImage);
    cv::Mat outImg;
    cvtColor(resultData.roughImg,outImg,COLOR_BGR2RGBA);
    UIImage *image =   MatToUIImage(outImg);
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"roughPoreCount"] = @(resultData.roughPoreCount);
    rDict[@"avgRadius"] = @(resultData.avgRadius);
    rDict[@"roughArea"] = @(resultData.roughArea);
    return rDict;
}
+(NSDictionary *)zhouwenWithWenLiImg:(UIImage *)wenLiImg {
    cv::Mat cvImage;
    UIImageToMat(wenLiImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);
    WrinkleData resultData = detectWrinkle(cvImage);
    cv::Mat outImg;
    cvtColor(resultData.wrinkleImg,outImg,COLOR_BGR2RGBA);
    UIImage *image =   MatToUIImage(outImg);
    
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"wrinkleCount"] = @(resultData.wrinkleCount);
    rDict[@"wrinkleLenth"] = @(resultData.wrinkleLenth);
    return rDict;
    
    
}
+(NSDictionary *)haoKongDuSheWithUVImg:(UIImage *)UVImg {
    
    cv::Mat cvImage;
    UIImageToMat(UVImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);
    
    BlockedPoreData resultData=detectBlocked(cvImage);
    cv::Mat outImg;
    cvtColor(resultData.blockedImg,outImg,COLOR_BGR2RGBA);
    UIImage *image =   MatToUIImage(outImg);
    
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"blockedArea"] = @(resultData.blockedArea);
    rDict[@"blockedCount"] = @(resultData.blockedCount);
    return rDict;
}
+(NSDictionary *)piZhiDuSheWithRiGuangImg:(UIImage *)RiGuangImg{


    cv::Mat cvImage;
    UIImageToMat(RiGuangImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);

 cv::Mat map = cv::Mat::zeros(cvImage.rows, cvImage.cols, cvImage.type());
 float ratio = hormone_process(cvImage, map);
 cvtColor(map,map,COLOR_BGR2RGBA);



 UIImage *image =   MatToUIImage(map);
    
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"ratio"] = @(ratio);
    return rDict;
}
+(NSDictionary *)minGanWithJihuaImg:(UIImage *)jihuaImg {
    
    cv::Mat cvImage;
    UIImageToMat(jihuaImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);
    //    DKmaskPictureDraws *drawAi = [[DKmaskPictureDraws alloc]init];
    //棕色图
#pragma 棕色图 未完成
//    UIImage *pinkimage = [self getPinkImage:jihuaImg] ;//[drawAi getAIpic:PinkImageType with:img and:img];
//    UIImageToMat(pinkimage, cvPinkimage);
    cv::Mat cvPinkGray;
    cv::Mat cvPinkimage;
    pink_image_processing(cvImage, cvPinkGray, cvPinkimage);

    cv::Mat map = cv::Mat::zeros(cvImage.rows, cvImage.cols, cvImage.type());
    float ratio = red_process(cvImage, cvPinkimage, map);
    cvtColor(map,map,COLOR_BGR2RGBA);
    UIImage *image =   MatToUIImage(map);
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"ratio"] = @(ratio);
    return rDict;
}
+(NSDictionary *)seChenWithJihuaImg:(UIImage *)jihuaImg{
    
    cv::Mat cvImage;
    UIImageToMat(jihuaImg, cvImage);
    cvtColor(cvImage,cvImage,COLOR_RGBA2BGR);
    
    cv::Mat gray, brown_image;
    
    int a = brown_image_processing(cvImage, gray, brown_image);
    //  DKopencvDrawPic *drawAi = [[DKopencvDrawPic alloc]init];
    
    
    
    // UIImage *dullimage = [UIImage imageNamed:@"zongse"];
    
    cv::Mat map = cv::Mat::zeros(cvImage.rows, cvImage.cols, cvImage.type());
    float ratio = dull_process(cvImage, brown_image, map);
    cvtColor(map,map,COLOR_BGR2RGBA);
    UIImage *image =   MatToUIImage(map);
    NSMutableDictionary *rDict = [NSMutableDictionary new];
    rDict[@"image"] = image;
    rDict[@"ratio"] = @(ratio);
    return rDict;
}




@end
