#include <fstream>
#include <math.h>
#include <stdlib.h>
#include <stdio.h>
#include <vector>
#include <iostream>
#include <sys/time.h>
#include <string.h>


#include <opencv2/opencv.hpp>
using namespace std;
using namespace cv;

int get_peak_cbcr2(vector<Point2f> pts, unsigned char& cb_peak, unsigned char& cr_peak);
void create_brown_a(double* a, double min_a, double max_a);
void create_brown_offsets(double* offsets, double y1, double y2);
int brown_image_processing(Mat img, Mat& gray, Mat& brown_image);

//int main()
//{
//	cv::Mat image = cv::imread("./0.jpg");
//    // cv::Mat mask = cv::imread("./1.jpg", 0);
//
//	if(image.empty())
//	{
//		cout << "can&apos;t openc the file!" << endl;
//		return -1;
//	}
//	cv::Mat gray, brown_image;
//
//    int a = brown_image_processing(image, gray, brown_image);
//}



// 灰度图的r,g,b通道的色度卡
const unsigned char brown_gray_r[256] = { 96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,  96,
									 96,  96,  96,  96,  96,  96,  96,  98, 100, 103, 105, 108, 111, 113, 115,	117,
									119, 121, 122, 124, 125, 127, 128, 129, 131, 132, 133, 134, 136, 137, 138, 139,
									140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 151, 152, 153, 154,
									155, 156, 156, 157, 158, 159, 160, 161, 161, 162, 163, 163, 164, 165, 166, 166,
									167, 168, 168, 169, 170, 171, 171, 172, 173, 173, 174, 175, 175, 176, 176, 177,
									178, 178, 179, 180, 180, 181, 181, 182, 183, 183, 184, 185, 185, 186, 186, 187,
									188, 188, 188, 189, 190, 190, 191, 191, 192, 193, 193, 194, 194, 195, 195, 196,
									196, 197, 198, 198, 199, 199, 200, 200, 201, 201, 202, 203, 203, 204, 204, 204,
									205, 206, 206, 206, 207, 208, 208, 209, 209, 209, 210, 211, 211, 211, 212, 213,
									213, 214, 214, 215, 215, 215, 216, 216, 217, 218, 218, 218, 219, 219, 220, 220,
									221, 221, 222, 222, 223, 223, 224, 224, 224, 225, 226, 226, 226, 227, 227, 228,
									228, 229, 229, 229, 230, 231, 231, 231, 232, 232, 233, 233, 234, 234, 234, 235,
									236, 236, 236, 237, 237, 238, 238, 238, 239, 239, 240, 240, 241, 241, 241, 242,
									242, 243, 243, 243, 244, 244, 245, 245, 246, 246, 247, 247, 247, 248, 248, 248,
									249, 249, 250, 250, 251, 251, 251, 252, 252, 253, 253, 253, 254, 254, 254, 255};
const unsigned char brown_gray_g[256] = {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   2,   4,   8,  11,  14,  17,  19,  22,  25,  27,  30,  31,  35,  36,  39,  40,  43,  45,  47,  49,  50,  53,  54,  56,  57,  59,  61,  63,  64,  66,  68,  69,  71,  72,  73,  75,  77,  78,  80,  81,  82,  84,  85,  87,  88,  89,  91,  92,  93,  94,  96,  97,  98, 100, 101, 102, 103, 105, 106, 107, 108, 110, 111, 112, 113, 114, 115, 116, 117, 119, 120, 121, 122, 123, 124, 125, 126, 128, 129, 130, 131, 132, 133, 134, 135, 135, 137, 138, 139, 140, 141, 142, 143, 144, 145, 145, 148, 148, 150, 150, 151, 152, 153, 154, 154, 156, 157, 158, 159, 160, 161, 162, 163, 164, 164, 166, 167, 168, 168, 169, 170, 171, 172, 173, 173, 175, 176, 177, 177, 178, 179, 180, 181, 182, 183, 183, 184, 185, 186, 187, 188, 189, 189, 191, 191, 192, 192, 194, 195, 196, 196, 197, 198, 199, 200, 200, 201, 202, 202, 204, 205, 205, 206, 207, 208, 209, 209, 210, 211, 211, 213, 214, 214, 215, 216, 217, 218, 218, 219, 220, 221, 221, 222, 223, 224, 225, 225, 226, 227, 228, 228, 229, 230, 230, 232, 232, 233, 234, 234, 235, 236, 237, 237, 238, 239, 240, 240, 241, 242, 243, 243, 244, 245, 246, 246, 247, 248, 248, 249, 249, 251, 252, 252, 253, 254, 254, 255};
const unsigned char brown_gray_b[256] = {  0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   0,   1,   3,   6,   7,   9,  11,  12,  15,  18,  19,  21,  23,  24,  27,  28,  31,  32,  34,  35,  37,  39,  40,  43,  44,  46,  47,  49,  51,  52,  55,  56,  58,  59,  61,  62,  64,  65,  67,  68,  70,  71,  73,  74,  76,  78,  79,  81,  82,  83,  85,  86,  88,  89,  91,  92,  94,  95,  96,  97,  98, 100, 102, 103, 104, 105, 107, 108, 109, 111, 111, 114, 114, 116, 117, 119, 120, 121, 122, 123, 125, 126, 128, 129, 131, 132, 134, 134, 136, 137, 138, 139, 140, 141, 143, 144, 146, 146, 148, 149, 150, 151, 152, 153, 155, 156, 158, 159, 160, 160, 161, 162, 164, 165, 167, 167, 170, 170, 172, 172, 173, 174, 176, 176, 178, 179, 180, 181, 182, 183, 185, 185, 186, 187, 188, 189, 190, 192, 193, 194, 195, 197, 197, 198, 199, 200, 201, 202, 204, 205, 206, 207, 208, 210, 210, 211, 212, 213, 214, 215, 216, 217, 219, 219, 221, 222, 222, 224, 224, 225, 226, 227, 228, 230, 231, 231, 233, 234, 235, 236, 236, 237, 238, 239, 240, 242, 243, 243, 245, 246, 246, 247, 248, 249, 250, 251, 252, 253, 254, 255};


const double brown_percentages[] = {0.05980, 0.06346, 0.06736, 0.07151, 0.07593, 0.08064, 0.08566, 0.09100, 0.09669, 0.10275, 0.10920, 0.11606, 0.12336, 0.13112, 0.13936, 0.14811, 
								0.15739, 0.16723, 0.17766, 0.18869, 0.20034, 0.21265, 0.22562, 0.23928, 0.25363, 0.26868, 0.28445, 0.30093, 0.31811, 0.33598, 0.35452, 0.37372, 
								0.39352, 0.41390, 0.43479, 0.45616, 0.47791, 0.50000, 0.52233, 0.54483, 0.56739, 0.58994, 0.61237, 0.63459, 0.65650, 0.67803, 0.69907, 0.71956, 
								0.73941, 0.75856, 0.77696, 0.79456, 0.81131, 0.82721, 0.84221, 0.85633, 0.86956, 0.88190, 0.89337, 0.90399, 0.91380, 0.92282, 0.93108, 0.93862, 
								0.94549, 0.95173, 0.95736, 0.96245, 0.96702, 0.97111, 0.97477, 0.97803, 0.98092, 0.98348, 0.98574, 0.98773, 0.98948, 0.99101, 0.99234, 0.99350, 
								0.99450, 0.99536, 0.99611, 0.99675, 0.99729, 0.99776, 0.99815, 0.99848, 0.99876, 0.99899, 0.99918, 0.99935, 0.99948, 0.99959, 0.99967, 0.99974, 
								0.99980, 0.99985, 0.99988, 0.99991, 0.99993, 0.99995, 0.99996, 0.99997, 0.99998, 0.99999, 0.99999, 0.99999, 1.00000, 1.00000, 1.00000, 1.00000};


/*
计算cb,cr通道的均值
*/
int get_peak_cbcr2(vector<Point2f> pts, unsigned char& cb_peak, unsigned char& cr_peak)
{
	int sum_cb, sum_cr, len;
	len = pts.size();
	sum_cb = 0;
	sum_cr = 0;
	for (int i = 0; i < len; i++) {
		sum_cb += pts[i].x; // cb
		sum_cr += pts[i].y; // cr
	}

	cb_peak = sum_cb / len;
	cr_peak = sum_cr / len;

	return 0;
}

void create_brown_a(double* a, double min_a, double max_a)
{
	int i = 0;

	for (i = 0; i < 16; i++) {
		a[i] = min_a;
	}
	for (i = 16; i < 256; i++) {
		a[i] = (max_a - min_a) * (1 - exp(-0.5 * (i - 16) * (i - 16) / (50 * 50))) + min_a;
	}
}

void create_brown_offsets(double* offsets, double y1, double y2)
{
	int x1 = 15;
	int x2 = 230;
	double d = 15; // cl: 11.5
	double maxy = exp((x2 - x1) / (d * d)) - 1;
	double y;

	for (int i = 0; i < x1; i++)
		offsets[i] = y1;

	for (int i = x1; i < x2; i++) {
		y = exp((x2 - i) / (d * d)) - 1;
		offsets[i] = y * (y1 - y2) / maxy + y2;
	}

	for (int i = x2; i < 256; i++)
		offsets[i] = y2;

}


int brown_image_processing(Mat img, Mat& gray, Mat& brown_image)
{
	char filename[256];
	int width, height;
	int r, g, b;
	int y, cb, cr;
	unsigned char peak_cb, peak_cr;
	double y1, y2;
	double brown_offsets[256];
	double brown_a[256];
	double brown_angle, brown_k, brown_R;
    const double PI = 3.1415926;
	const double brown_percentages[] = {0.05980, 0.06346, 0.06736, 0.07151, 0.07593, 0.08064, 0.08566, 0.09100, 0.09669, 0.10275, 0.10920, 0.11606, 0.12336, 0.13112, 0.13936, 0.14811, 
					0.15739, 0.16723, 0.17766, 0.18869, 0.20034, 0.21265, 0.22562, 0.23928, 0.25363, 0.26868, 0.28445, 0.30093, 0.31811, 0.33598, 0.35452, 0.37372, 
					0.39352, 0.41390, 0.43479, 0.45616, 0.47791, 0.50000, 0.52233, 0.54483, 0.56739, 0.58994, 0.61237, 0.63459, 0.65650, 0.67803, 0.69907, 0.71956, 
					0.73941, 0.75856, 0.77696, 0.79456, 0.81131, 0.82721, 0.84221, 0.85633, 0.86956, 0.88190, 0.89337, 0.90399, 0.91380, 0.92282, 0.93108, 0.93862, 
					0.94549, 0.95173, 0.95736, 0.96245, 0.96702, 0.97111, 0.97477, 0.97803, 0.98092, 0.98348, 0.98574, 0.98773, 0.98948, 0.99101, 0.99234, 0.99350, 
					0.99450, 0.99536, 0.99611, 0.99675, 0.99729, 0.99776, 0.99815, 0.99848, 0.99876, 0.99899, 0.99918, 0.99935, 0.99948, 0.99959, 0.99967, 0.99974, 
					0.99980, 0.99985, 0.99988, 0.99991, 0.99993, 0.99995, 0.99996, 0.99997, 0.99998, 0.99999, 0.99999, 0.99999, 1.00000, 1.00000, 1.00000, 1.00000};
	int brown_percentages_length = sizeof(brown_percentages) / sizeof(double);

	Mat ycbcrimg;

	if (img.empty())
    {
		return -1;
	}
	width = img.cols;
	height = img.rows;
	// ycbcrimg = img.clone(); // Mat(img.size(), CV_8UC3);
	vector<Point2f> pts;
	cvtColor(img, ycbcrimg, COLOR_BGR2YCrCb);
	vector<Mat> imgs;
	split(ycbcrimg, imgs);
	imgs[0] = imgs[0] + 16;
	merge(imgs, ycbcrimg);
	for (int i = 0; i < height; i+=8) {
		// uchar* pmask = mask.data + mask.step * i;
		uchar* pycbcr = ycbcrimg.data + ycbcrimg.step * i;
		for (int j = 0; j < width; j+=8) {

			cr = pycbcr[3*j + 1];
			cb = pycbcr[3*j + 2];
			pts.push_back(Point2f(cb, cr));

		}
	}
	peak_cb = 0; peak_cr = 0;
	get_peak_cbcr2(pts, peak_cb, peak_cr);
	brown_angle = 18 * PI / 180;
	brown_k = tan(brown_angle);
	brown_R = sqrt(brown_k*brown_k + 1);
	create_brown_a(brown_a, 0.550, 0.1556);
	y1 = -90;
	y2 = (30 * brown_R + brown_k * peak_cr - peak_cb);
	create_brown_offsets(brown_offsets, y1, y2);

	gray = Mat(img.size(), CV_8UC1);
	if (gray.empty())
	{
		return -2;
	}
	for (int i = 0; i < height; i++)
	{
		uchar* pgray = gray.ptr<uchar>(i); // gray.data + gray.step * i;
		uchar* pycbcr = ycbcrimg.ptr<uchar>(i); // ycbcrimg.data + ycbcrimg.step * i;
		for (int j = 0; j < width; j++)
		{
			int t;
			y =  pycbcr[0];
			cr = pycbcr[1];
			cb = pycbcr[2];

			double d = (cb - brown_k * cr + brown_offsets[y]) / brown_R;
			if (y < brown_percentages_length)
				d = d * brown_percentages[y] + 25 * (1 - brown_percentages[y]);
			t = (int)(brown_a[y] * d * d + 22);
			if (t > 255)
				t = 255;
			else if (t < 0)
				t = 0;
			*pgray = t;
			pgray++;
			pycbcr += 3;
		}
	}
	// Mat tgray, imggray;
	// Ptr<cv::CLAHE> clahe = createCLAHE(3.5, Size(32, 32));
	// clahe->apply(gray, tgray);
	// cvtColor(img, imggray, COLOR_BGR2GRAY);
	// imggray *= 1.5;
	// imggray.convertTo(imggray, CV_32FC1);
	// tgray.convertTo(tgray, CV_32FC1);
	// imggray /= 255.;
	// gray.convertTo(gray, CV_32FC1);
	// gray = gray + imggray.mul(tgray - gray);
	// gray.convertTo(gray, CV_8UC1);

	// GaussianBlur(gray, gray, Size(5, 5), 1.6);

	Mat brown_color(256, 1, CV_8UC3);
	for(int i = 0; i < 256; i++) {
		brown_color.at<Vec3b>(i)[0] = brown_gray_b[i];
		brown_color.at<Vec3b>(i)[1] = brown_gray_g[i];
		brown_color.at<Vec3b>(i)[2] = brown_gray_r[i];
	}
	// Mat brown_image;
	applyColorMap(gray, brown_image, brown_color);
	cv::imwrite("./3.jpg", brown_image);

	// imwrite(filepath, brown_image);
	return 0;
}
