package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-员工使用设备统计数据日表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_employee_use_device_count_by_day")
public class DrEmployeeUseDeviceCountByDayEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 当天日期
	 */
	private String dailyTime;
	/**
	 * 操作次数
	 */
	private Integer operateNum;
	/**
	 * 员工姓名
	 */
	private String employeeName;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegion;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;

}
