package com.dr.util;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * Created with IntelliJ IDEA.
 *
 * @Auther: zhangyouhui
 * @Date: 2021/03/09/10:05
 * @Description: 微信小程序常量配置类
 */
@Component
@PropertySource("classpath:AppConstant.properties")
public class WxAppletsConstant {

    /**
     * 小程序 appId
     */
    @Value("${AppConstant.APPID}")
    private  String APP_ID ="";
    /**
     * 小程序 appSecret
     */
    @Value("${AppConstant.SECRET}")
    private  String SECRET = "";
    /**
     * 授权类型
     */
    @Value("${AppConstant.GRANTTYPE}")
    private  String GRANT_TYPE = "";
    /**
     * 获取OpenId 及SeesionKey的url地址
     */
    @Value("${AppConstant.GETOPENIDURL}")
    private  String GET_OPENID_URL = "";

    /**
     * redis存储token目录
     */
    @Value("${AppConstant.BEOVERDUE_TOEKN}")
    private  String BEOVERDUE_TOEKN = "";

    /**
     *
     * redis存储sessionkey目录
     */
    @Value("${AppConstant.BEOVERDUE_SESSIONKEY}")
    private  String BEOVERDUE_SESSIONKEY = "";


    // Token 默认过期时间15天
    @Value("${AppConstant.TOKENDFTEXPIRETIME}")
    private Integer TOKEN_DFT_EXPIRE_TIME ;

    @Value("${AppConstant.DEVICETYPE}")
    private String DEVICETYPE;


    public String getBEOVERDUE_TOEKN() {
        return BEOVERDUE_TOEKN;
    }

    public String getBEOVERDUE_SESSIONKEY() {
        return BEOVERDUE_SESSIONKEY;
    }

    public String getDEVICETYPE() {
        return DEVICETYPE;
    }

    public String getAPP_ID() {
        return APP_ID;
    }

    public String getSECRET() {
        return SECRET;
    }

    public String getGRANT_TYPE() {
        return GRANT_TYPE;
    }

    public String getGET_OPENID_URL() {
        return GET_OPENID_URL;
    }

    public Integer getTOKEN_DFT_EXPIRE_TIME() {
        return TOKEN_DFT_EXPIRE_TIME;
    }

}
