package com.dr.aspect;

import com.alibaba.fastjson2.JSON;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component
@Slf4j
public class AreaConfigServiceAspect {

    private static final String POINTCUT = "execution(* com.dr.service..*(..))";

    @Before(POINTCUT)
    public void logBeforeMethodExecution(JoinPoint joinPoint){
        String methodName = joinPoint.getSignature().getName();
        Object[] args = joinPoint.getArgs();
        log.info("Method: " + methodName);
        for(Object arg : args){
            log.info("Argument:" + args);
        }
    }

    @AfterReturning(pointcut = POINTCUT, returning = "result")
    public void logAfterMethodExecution(JoinPoint joinPoint, Object result){
        MethodSignature signature = (MethodSignature) joinPoint.getSignature();
        String methodName = signature.getName();
        log.info("After executing method: " + methodName);
        log.info("Return value: " + result);

    }

}
