package com.dr.aspect;

import com.alibaba.fastjson2.JSON;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Before;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

/**
 * 请求参数输出 AOP
 *
 * @author luocong
 * @since 2024/3/11 10:15
 **/
@Aspect
@Component
@Slf4j
public class RequestParamsAspect {

    /**
     * 执行拦截
     */
    @Before("execution(* com.dr.controller.*.*.*(..))")
    public void doInterceptor(JoinPoint joinPoint) {
        HttpServletRequest request = ((ServletRequestAttributes) Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
        String url = request.getRequestURI();
        //请求参数
        Object[] args = joinPoint.getArgs();
        List<Object> argsList=new ArrayList<>();
        for (Object arg : args) {
            // 如果参数类型是请求和响应的http，则不需要拼接
            if (arg instanceof HttpServletRequest || arg instanceof HttpServletResponse || arg instanceof MultipartFile) {
                continue;
            }
            argsList.add(arg);
        }
        log.info("Request url:{}, Request parameters:{}", url, JSON.toJSONString(argsList));
    }

}