package com.dr.config;

import org.springframework.context.annotation.Configuration;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

/**
 * @Description: 常量配置
 * @Author: luocong
 * @Since: 2022/8/5
 * @Version: 1.0.0
 */
@Configuration
public class ConstantConfig {

    public static final Map<String, String> CHECK_DEVICE_MAP;

    static {
        //检测类仪器包含：猫咪一代（DBQ3-3）、猫咪二代（DAF03-1）、Metis（DBQ3-1）、头皮镜（DAS02-1）、水肤镜（DAS01-1）
        HashMap<String, String> checkMap = new HashMap<>();
        checkMap.put(ConstantConfig.CAT_ONE, "猫咪一代");
        checkMap.put(ConstantConfig.CAT_TWO, "猫咪二代");
        checkMap.put("DAS01-1", "水肤镜");
        checkMap.put(ConstantConfig.METIS, "Metis");
        checkMap.put("DAS02-1", "头皮镜");
        CHECK_DEVICE_MAP = Collections.unmodifiableMap(checkMap);
    }

    /**
     * 获取所有员工的权限接口
     */
    public static final String PERMISSIONS_URL = "/Face/selectAllPermissions";

    /**
     * 成功返回的状态标识:success=true
     */
    public static final String BACK_FLAG = "success";

    /**
     * redis新增客户ID与案例ID缓存的数据前缀
     */
    public static final String BEFORE_STR = "before:";

    /**
     * redis新增客户ID缓存的数据后缀
     */
    public static final String CG_ID_BEFORE_STR = "CIdBefore";

    /**
     * 数据统计缓存base_key
     */
    public static final String BASE_REDIS_KEY = "metis";

    /**
     * 客户数据统计缓存key
     */
    public static final String CLIENT_REDIS_KEY = ":newclient:";

    /**
     * 案例组数据统计缓存key
     */
    public static final String CASE_GROUP_REDIS_KEY = ":casegroup:";

    /**
     * 客户到店数据统计缓存key
     */
    public static final String CUSTOMERS_TO_SHOP_REDIS_KEY = ":customerstoshop:";

    /**
     * DBQ3-3   猫咪一代
     */
    public static final String CAT_ONE = "DBQ3-3";

    /**
     * DAF03-1   猫咪二代
     */
    public static final String CAT_TWO = "DAF03-1";

    /**
     * DBQ3-1   metis
     */
    public static final String METIS = "DBQ3-1";

    /**
     * 到店频次
     */
    public static final String SHOP_FREQUENCY_REDIS_KEY = ":shopfrequency:";

    /**
     * 到店排行数据统计缓存key
     */
    public static final String SHOP_RANKING_REDIS_KEY = ":shopranking:";

    /**
     * 年龄分布数据统计缓存key
     */
    public static final String AGE_DISTRIBUTION_REDIS_KEY = ":agedistribution:";

    /**
     * 地域分布数据统计缓存key
     */
    public static final String REGIONAL_DISTRIBUTION_REDIS_KEY = ":regionaldistribution:";

    /**
     * 检测排行数据统计缓存key
     */
    public static final String CHECK_CASE_RANK_REDIS_KEY = ":checkcaserank:";

    /**
     * 症状统计数据统计缓存key
     */
    public static final String SYMPTOMS_REDIS_KEY = ":symptoms:";

    /**
     * 产品推广曝光缓存key
     */
    public static final String PRODUCT_REDIS_KEY = ":product:";

    /**
     * 检测类仪器
     */
    public static final String DEVICE_TYPE = "check_device";

    /**
     * 检测类仪器
     */
    public static final String WATERSKIN_DEVICE_TYPE = "waterskin_device";

    /**
     * 检测类仪器
     */
    public static final String WATERSKIN_CODE = "waterskin_code";

    /**
     * 皮肤问题推荐方案
     */
    public static final String SKIN_PROBLEM_RECOMMEND = "skipproblem";

    /**
     * 到店次数缓存key
     */
    public static final String ARRIVE_SHOP_REDIS_KEY = ":arrive_shop:";

    /**
     * 门店机构缓存key
     */
    public static final String ORG_INFO_REDIS_KEY = ":org_info";

}
