package com.dr.constant;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;
import lombok.ToString;

import java.io.Serializable;

/**
 * @author luocong
 * @since 2023-01-29 14:24:53
 */
@ToString
@AllArgsConstructor
@NoArgsConstructor
@Data
public class CodeMsg implements Serializable {

    private static final long serialVersionUID = 9116840345586813365L;

    private int code;
    private String msg;

    /**
     * 正常返回
     */
    public static final CodeMsg SUCCESS = new CodeMsg(0, "ok");

    /**
     * 通用的错误码
     */
    public static final CodeMsg SERVER_ERROR = new CodeMsg(-2, "Server Error");
    public static final CodeMsg TOKEN_ERROR = new CodeMsg(-1, "当前会话已失效,请重新登录");
    public static final CodeMsg PARAMETER_VALIDATOR = new CodeMsg(1, "Invalid Parameter");
    public static final CodeMsg BAD_REQUEST = new CodeMsg(2, "Bad Request");

}