package com.dr.controller;

import com.dr.controller.BaseController;
import com.dr.filter.token.JwtHelper;
import com.dr.service.IMeowShopDataReportService;
import com.dr.util.PageUtils;
import com.dr.util.Result;
import com.dr.vo.*;
import io.swagger.annotations.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @description 美业喵店小程序数据报告
 * @author luocong
 * @date 2024/7/26 10:55
 * @version 1.0
 */
@Api(tags = "美业喵店小程序数据报告")
@RequestMapping("/djmaftersales/dataReport")
@RestController
public class MeowShopDataReportController extends BaseController {

    @Autowired
    private IMeowShopDataReportService meowShopDataReportService;

    @ApiOperation(value = "业绩排行", notes = "业绩排行", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lineCityId", value = "城市线id", required = true, dataType = "long")
    })
    @PostMapping("/performanceRank")
    public Result<List<NewPerformanceRankVO>> performanceRank(HttpServletRequest request, JwtHelper jwtHelper, @RequestParam(value = "lineCityId") Long lineCityId) {

        return this.meowShopDataReportService.performanceRank(request, jwtHelper, lineCityId);
    }

    @ApiResponses({
            @ApiResponse(code = 0, message = "url下载链接", response = Result.class)
    })
    @ApiOperation(value = "业绩报表下载", notes = "业绩报表下载", httpMethod = "POST")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "lineCityId", value = "城市线id", required = true, dataType = "long"),
    })
    @PostMapping("/performanceDownload")
    public Result<Void> performanceDownload(HttpServletRequest request, JwtHelper jwtHelper, @RequestParam(value = "lineCityId") Long lineCityId) {

        return this.meowShopDataReportService.performanceDownload(request, jwtHelper, lineCityId);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "shopAccount", value = "门店账号集", dataType = "array"),
            @ApiImplicitParam(name = "selectType", value = "选择类型（0-我的，1-全国）", required = true, dataType = "int", paramType = "form")
    })
    @ApiOperation(value = "耗材消耗排行", notes = "耗材消耗排行", httpMethod = "POST")
    @PostMapping("/consumableRank")
    public Result<List<NewConsumableRankVO>> selectConsumableRank(HttpServletRequest request, JwtHelper jwtHelper,
                                                                  @RequestParam(value = "shopAccount", required = false) String[] shopAccount,
                                                                  @RequestParam(value = "selectType") Integer selectType) {

        return this.meowShopDataReportService.selectConsumableRank(request, jwtHelper, shopAccount, selectType);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "shopAccount", value = "门店账号集", dataType = "array"),
            @ApiImplicitParam(name = "selectType", value = "选择类型（0-我的，1-全国）", required = true, dataType = "int", paramType = "form")
    })
    @ApiOperation(value = "耗材消耗报表下载", notes = "耗材消耗报表下载", httpMethod = "POST")
    @PostMapping("/consumableDownload")
    public Result<Void> newConsumableDownload(HttpServletRequest request, JwtHelper jwtHelper,
                                                @RequestParam(value = "shopAccount", required = false) String[] shopAccount,
                                                @RequestParam(value = "selectType") Integer selectType) {

        return this.meowShopDataReportService.newConsumableDownload(request, jwtHelper, shopAccount, selectType);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "regionId", value = "区域id", required = true, dataType = "long")
    })
    @ApiOperation(value = "皮肤问题推荐方案接口", notes = "皮肤问题推荐方案接口", httpMethod = "POST")
    @PostMapping("/skinProblemRecommend")
    public Result<List<SkinProblemRecommendVO>> selectSkinProblemRecommend(@RequestParam(value = "regionId") Long regionId) {

        return this.meowShopDataReportService.selectSkinProblemRecommend(regionId);
    }

    @ApiOperation(value = "设备与耗材数据", notes = "设备与耗材数据", httpMethod = "POST")
    @PostMapping("/deviceAndConsumable")
    public Result<NewDeviceAndConsumableVO> selectDeviceAndConsumable(HttpServletRequest request, JwtHelper jwtHelper) {

        return this.meowShopDataReportService.selectDeviceAndConsumable(request, jwtHelper);
    }

    @ApiOperation(value = "设备实时使用情况", notes = "设备实时使用情况", httpMethod = "POST")
    @PostMapping("/deviceRealTime")
    public Result<List<NewDeviceRealTimeVO>> selectDeviceRealTime(HttpServletRequest request, JwtHelper jwtHelper) {

        return this.meowShopDataReportService.selectDeviceRealTime(request, jwtHelper);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "flag", value = "日期 1-昨天 2-近七天 3-近三十天", required = true, dataType = "int"),
            @ApiImplicitParam(name = "shopAccount", value = "门店账号集,全选不要传值", dataType = "array")
    })
    @ApiOperation(value = "员工排行数据", notes = "员工排行数据", httpMethod = "POST")
    @PostMapping("/empOperateRank")
    public Result<List<NewEmployeeRankVO>> empOperateRank(HttpServletRequest request, JwtHelper jwtHelper, Integer flag, String[] shopAccount) {

        return this.meowShopDataReportService.selectEmpOperateRank(request, jwtHelper, flag, shopAccount);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "flag", value = "日期 1-昨天 2-近七天 3-近三十天", required = true, dataType = "int"),
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "门店消耗排行数据", notes = "门店消耗排行数据", httpMethod = "POST")
    @PostMapping("/shopConsumerRank")
    public Result<PageUtils> shopConsumerRank(HttpServletRequest request, JwtHelper jwtHelper,
                                              @RequestParam("flag") Integer flag,
                                              @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                              @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectShopConsumerRank(request, jwtHelper, flag, pageNum, pageSize);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "deviceCode", value = "设备类型code", dataType = "string"),
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "设备地域分布", notes = "设备地域分布", httpMethod = "POST")
    @PostMapping("/regionalDistribution")
    public Result<PageUtils> regionalDistribution(HttpServletRequest request, JwtHelper jwtHelper,
                                                  @RequestParam("deviceCode") String[] deviceCode,
                                                  @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                  @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectRegionalDistribution(request, jwtHelper, deviceCode, pageNum, pageSize);
    }

    @ApiOperation(value = "客户与案例", notes = "客户与案例", httpMethod = "POST")
    @PostMapping("/clientAndCase")
    public Result<NewClientAndCaseGroupVO> clientAndCase(HttpServletRequest request, JwtHelper jwtHelper) {

        return this.meowShopDataReportService.selectClientAndCase(request, jwtHelper);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "flag", value = "日期 1-昨天 2-近七天 3-近三十天", required = true, dataType = "int"),
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "检测排行", notes = "检测排行", httpMethod = "POST")
    @PostMapping("/checkCaseRank")
    public Result<PageUtils> checkCaseRank(HttpServletRequest request, JwtHelper jwtHelper,
                                           @RequestParam("flag") Integer flag,
                                           @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                           @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectCheckCaseRank(request, jwtHelper, flag, pageNum, pageSize);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "产品推广曝光", notes = "产品推广曝光", httpMethod = "POST")
    @PostMapping("/productRecommend")
    public Result<PageUtils> productRecommend(HttpServletRequest request, JwtHelper jwtHelper,
                                              @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                              @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectProductRecommend(request, jwtHelper, pageNum, pageSize);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "flag", value = "日期 1-昨天 2-近七天 3-近三十天", required = true, dataType = "int"),
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "客户到店排行", notes = "客户到店排行", httpMethod = "POST")
    @PostMapping("/arriveShopRank")
    public Result<PageUtils> selectArriveShopRank(HttpServletRequest request, JwtHelper jwtHelper,
                                                  @RequestParam("flag") Integer flag,
                                                  @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                  @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectArriveShopRank(request, jwtHelper, flag, pageNum, pageSize);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "shopAccount", value = "门店账号集", dataType = "array")
    })
    @ApiOperation(value = "年龄分布", notes = "年龄分布", httpMethod = "POST")
    @PostMapping("/ageDistribution")
    public Result<List<NewAgeDistributionVO>> selectAgeDistribution(HttpServletRequest request, JwtHelper jwtHelper, String[] shopAccount) {

        return this.meowShopDataReportService.selectAgeDistribution(request, jwtHelper, shopAccount);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "客户地域分布", notes = "设备地域分布", httpMethod = "POST")
    @PostMapping("/clientDistribution")
    public Result<PageUtils> selectClientDistribution(HttpServletRequest request, JwtHelper jwtHelper,
                                                      @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                      @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectClientDistribution(request, jwtHelper, pageNum, pageSize);
    }

    @ApiImplicitParams({
            @ApiImplicitParam(name = "pageNum", value = "页数,默认1", dataType = "int"),
            @ApiImplicitParam(name = "pageSize", value = "条数,默认5", dataType = "int")
    })
    @ApiOperation(value = "下载中心查询列表", notes = "下载中心查询列表", httpMethod = "POST")
    @PostMapping("/downloadCenter/list")
    public Result<PageUtils> selectDownloadList(HttpServletRequest request, JwtHelper jwtHelper,
                                                @RequestParam(value = "pageNum", defaultValue = "1") Integer pageNum,
                                                @RequestParam(value = "pageSize", defaultValue = "5") Integer pageSize) {

        return this.meowShopDataReportService.selectDownloadList(request, jwtHelper, pageNum, pageSize);
    }

}
