package com.dr.dto;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.PropertySource;
import org.springframework.stereotype.Component;

/**
 * @ClassName: BranchMoistenDTO
 * @Description: 分润配置表
 * @Author: zhangyouhui
 * @Date: 2021/12/23 17:20
 */
@Component
@PropertySource("classpath:AppConstant.properties")
public class BranchMoistenDTO {
    /**
     *员工登录token
     */
    @Value("${AppConstant.BRANCHMOISTEN.TOKEN}")
    private String TOKEN;

    /**
     *员工登录token过期时间
     */
    @Value("${AppConstant.BRANCHMOISTEN.TOKENBEOVERDUE}")
    private Integer TOKENBEOVERDUE;

    public String getTOKEN() {
        return TOKEN;
    }


    public Integer getTOKENBEOVERDUE() {
        return TOKENBEOVERDUE;
    }
}
