package com.dr.dto;

import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.ToString;

import java.io.Serializable;
import java.util.List;

/**
 * @Description:
 * @Author: luocong
 * @Since: 2022/8/15
 * @Version: 1.0.0
 */
@Data
@ToString
@EqualsAndHashCode
public class OrgProductRecommendRedisDTO implements Serializable {

    private static final long serialVersionUID = -8595538396155010062L;

    /**
     * 机构ID
     */
    private Long oid;

    /**
     * 机构账户
     */
    private String oAccount;

    /**
     * 产品推荐
     */
    private List<ProductRecommendDTO> productRecommendList;

    /**
     * 门店产品推荐
     */
    private List<MemberProductRecommendDTO> memberProductRecommendList;

    /**
     * 创建时间
     */
    private String redisCreateTime;

}
