package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @description 城市地区分配表
 * @author luocong
 * @date 2023-10-16 11:43
 * @version 1.0
 */
@Data
@TableName("t_area_config")
public class AreaConfigEntity implements Serializable {
	private static final long serialVersionUID = -3642198331315443307L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 所属区域名称
	 */
	private String areaConfigName;
	/**
	 * 类型（0-城市线（1线，2线），1-区域，（如华东、华南地区））
	 */
	private Integer type;
	/**
	 * 创建时间
	 */
	private Date createTime;
	/**
	 * 修改时间
	 */
	private Date updateTime;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;

}
