package com.dr.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description 数据统计-客户年龄信息分布日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class DrClientAgeDistributeByDayEntity implements Serializable {

	private static final long serialVersionUID = 2181354370637403798L;

	public DrClientAgeDistributeByDayEntity(Integer eighteenYearUnder, Integer eighteenToThirtyYear, Integer thirtyToFortyYear, Integer fortyToSixtyYear, Integer sixtyYearOver) {
		this.eighteenYearUnder = eighteenYearUnder;
		this.eighteenToThirtyYear = eighteenToThirtyYear;
		this.thirtyToFortyYear = thirtyToFortyYear;
		this.fortyToSixtyYear = fortyToSixtyYear;
		this.sixtyYearOver = sixtyYearOver;
	}

	/**
	 * id
	 */
	private Long id;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 当天日期
	 */
	private LocalDate dailyTime;
	/**
	 * 0-男,1-女,2-未知
	 */
	private Integer sex;
	/**
	 * 18岁以下
	 */
	private Integer eighteenYearUnder;
	/**
	 * 18-3333
	 */
	private Integer eighteenToThirtyYear;
	/**
	 * 30-40岁
	 */
	private Integer thirtyToFortyYear;
	/**
	 * 40-60岁
	 */
	private Integer fortyToSixtyYear;
	/**
	 * 60岁以上
	 */
	private Integer sixtyYearOver;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegionName;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
