package com.dr.entity;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description 数据统计-顾客案例新增明细日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
public class DrNewAddClientAndCaseByDayEntity implements Serializable {
	private static final long serialVersionUID = -2821249833575095313L;

	/**
	 * id
	 */
	private Long id;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 当天日期
	 */
	private LocalDate dailyTime;
	/**
	 * 新增顾客数量
	 */
	private Integer addClientNum;
	/**
	 * 新增案例数量
	 */
	private Integer addCaseGroupNum;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 案例总数
	 */
	private Integer caseGroupNum;
	/**
	 * 客户总数
	 */
	private Integer clientNum;
	/**
	 * 单次到店客户数
	 */
	private Integer onceArriveClientNum;
	/**
	 * 多次到店客户数
	 */
	private Integer moreArriveClientNum;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegionName;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
