package com.dr.mapper;

import com.dr.entity.DrProductRecommendByDayEntity;
import com.dr.vo.NewProductRecommendVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description 数据统计-产品推广曝光数据日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@Mapper
public interface DrProductRecommendByDayMapper {

    /**
     * 批量插入数据
     *
     * @param resList
     */
    void saveBatch(List<DrProductRecommendByDayEntity> resList);

    /**
     * 查询产品推广曝光
     *
     * @param oAccount 机构账号
     * @param mAccount 门店账号
     * @param pageNum 页数
     * @param pageSize 条数
     * @return List<NewProductRecommendVO>
     */
    List<NewProductRecommendVO> selectList(@Param("oAccount") String oAccount, @Param("mAccount") String mAccount,
                                           @Param("pageNum") Integer pageNum, @Param("pageSize") Integer pageSize);

    /**
     * 统计产品推荐
     *
     * @param oAccount 机构账号
     * @param mAccount 门店账号
     * @return 数量
     */
    Long selectCount(@Param("oAccount") String oAccount, @Param("mAccount") String mAccount);
}
