package com.dr.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dr.entity.AreaConfigEntity;
import com.dr.mapper.AreaConfigMapper;
import com.dr.service.IAreaConfigService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class AreaConfigServiceImpl implements IAreaConfigService {

    @Autowired
    private AreaConfigMapper areaConfigMapper;

    @Override
    public List<AreaConfigEntity> getRegionList() {
        return areaConfigMapper.selectList(new LambdaQueryWrapper<AreaConfigEntity>().select(AreaConfigEntity::getId,
                        AreaConfigEntity::getAreaConfigName)
                .eq(AreaConfigEntity::getType, 1)
                .eq(AreaConfigEntity::getDeleted, 0));
    }

    @Override
    public List<AreaConfigEntity> getLineCityCode() {
        return areaConfigMapper.selectList(new LambdaQueryWrapper<AreaConfigEntity>().select(AreaConfigEntity::getId,
                        AreaConfigEntity::getAreaConfigName)
                .eq(AreaConfigEntity::getType, 0)
                .eq(AreaConfigEntity::getDeleted, 0));
    }
}
