package com.dr.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.dr.vo.HereMapGRevGeoVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @description here地图
 * @author luocong
 * @date 2024/8/26 13:54
 * @version 1.0
 */
@Slf4j
@Component
public class HereMapUtil {

    private static final String AK = "O5q6RIbVItEvOzB3aqb21dj6pmqI9DBZtgla_ZvymDc";

    public static Site getGeographyConvert(double latitude, double longitude) {
        String url = "https://revgeocode.search.hereapi.com/v1/revgeocode?at=" + latitude + "," + longitude + "&q=petrol+station&apiKey=" + AK;
        String body = null;
        try {
            body = HttpUtil.get(url);
            log.info("----------->>>HERE地图返回接口信息:{}", body);
            HereMapGRevGeoVO hereMapGRevGeoVO = JSON.parseObject(body, HereMapGRevGeoVO.class);
            HereMapGRevGeoVO.Item item = hereMapGRevGeoVO.getItems().get(0);
            Site site = new Site();
            site.setFormatted_address(item.getAddress().getLabel());
            site.setCountry(item.getAddress().getCountryName());
            site.setProvince(item.getAddress().getState());
            site.setCity(item.getAddress().getCounty());
            site.setDistrict(item.getAddress().getCity());
            site.setCountry_code(item.getAddress().getCountryCode());
            site.setAdcode("0");
            return site;
        } catch (Exception e) {
            log.error("----------->>>HERE地图接口调用错误:{}", body);
            return null;
        }
    }

    public static boolean isInChina(double latitude, double longitude) {
        return longitude >= 73.33 && longitude <= 135.05 && latitude >= 18.03 && latitude <= 53.33;
    }

}
