package com.dr.util;

import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.Map;

/**
 * @author songyouyu
 * @date 2022/6/9 15:15
 */
@Component
public class RabbitmqSendMessageUtil {

    @Resource
    private RabbitTemplate rabbitTemplate;

    private static RabbitmqSendMessageUtil rabbitmqSendMessageUtil;

    @PostConstruct
    public void init(){
        rabbitmqSendMessageUtil = this;
        rabbitmqSendMessageUtil.rabbitTemplate = this.rabbitTemplate;
    }

    /**
     * 发送延迟消息
     * @param exchange
     * @param routingKey
     * @param map
     * @param dateTime 毫秒
     */
    public static void sendDelayMessage(String exchange, String routingKey, Map<String, Object> map, Long dateTime) {
        rabbitmqSendMessageUtil.rabbitTemplate.convertAndSend(exchange, routingKey, map, message -> {
            message.getMessageProperties().setHeader("x-delay", dateTime);
            return message;
        });
    }

    /**
     * 用户下单后确定代理商门店绑定关系
     * @param exchange
     * @param routingKey
     * @param map
     */
    public static void sendProxyShopMessage(String exchange, String routingKey, Map<String, Object> map) {
        rabbitmqSendMessageUtil.rabbitTemplate.convertAndSend(exchange, routingKey, map);
    }

    /**
     * 用户购买指定商品开通VIP
     * @param exchange
     * @param routingKey
     * @param map
     */
    public static void sendUserVipMessage(String exchange, String routingKey, Map<String, Object> map) {
        rabbitmqSendMessageUtil.rabbitTemplate.convertAndSend(exchange, routingKey, map);
    }

}
