package com.dr.vo;

import com.alibaba.fastjson.JSON;

import java.io.Serializable;

/**
 * @Description: 接口返回模板
 * @Author: luocong
 * @Since: 2022/8/16
 * @Version: 1.0.0
 */
public class ApiTemplateVO<T> implements Serializable {

    /**
     * 数据
     */
    private T data;
    /**
     * 请求状态0 失败 1 成功
     */
    private Integer sign;
    /**
     * 提示信息
     */
    private String msg;
    /**
     * code业务代码
     */
    private Integer code;
    private String token;
    private Long total;


    /**
     * 操作成功
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO SUCCESS() {
        this.data = null;
        this.sign = 1;
        this.msg = "操作成功";
        this.code = 200;
        return this;
    }

    /**
     * 操作成功
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO SUCCESS(T data) {
        this.data = data;
        this.sign = 1;
        this.msg = "";
        this.code = 200;
        return this;
    }

    /**
     * 必填参数不能为空
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO NULL() {
        this.data = null;
        this.sign = 0;
        this.msg = "必填项不能为空";
        this.code = 1000;
        return this;
    }

    /**
     * 必填参数不能为空
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO DATA_NULL() {
        this.data = null;
        this.sign = 0;
        this.msg = "数据不存在,请检查参数";
        this.code = 1001;
        return this;
    }

    /**
     * 操作失败 ERROR 未处理异常
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO ERROR() {
        this.data = null;
        this.sign = 0;
        this.msg = "操作失败";
        this.code = 5000;
        return this;
    }


    /**
     * 操作失败 ERROR
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO ERROR(String msg, Integer code) {
        this.data = null;
        this.sign = 0;
        this.msg = msg;
        this.code = code;
        return this;
    }

    /**
     * 接口调用失败 warning try cash
     *
     * @return 响应数据模板
     */
    public ApiTemplateVO WARNING() {
        this.data = null;
        this.sign = 0;
        this.msg = "接口调用异常";
        this.code = 4444;
        return this;
    }

    /**
     * 推送数据模板
     *
     * @param data 数据
     * @param code 数据格式
     * @return
     */
    public ApiTemplateVO PUSH_DATA(T data, Integer code) {
        this.data = data;
        this.code = code;
        return this;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    @Override
    public String toString() {
        return JSON.toJSONString(this).replaceAll("http://", "https://");
    }


    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }

}
