package com.dr.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @description 年龄分布
 * @author luocong
 * @date 2023/12/4 11:40
 * @version 1.0
 */
@ApiModel(value = "NewAgeDistributionVO", description = "年龄分布对象")
@Data
public class NewAgeDistributionVO implements Serializable {

    private static final long serialVersionUID = 7183121346355376718L;

    @ApiModelProperty(value = "性别 0-男，1-女")
    private Integer sex;

    @ApiModelProperty(value = "60岁以上")
    private String overSixtyYear;

    @ApiModelProperty(value = "40-60岁")
    private String fortyToSixtyYear;

    @ApiModelProperty(value = "30-40岁")
    private String thirtyToFortyYear;

    @ApiModelProperty(value = "18-30岁")
    private String eighteenToThirtyYear;

    @ApiModelProperty(value = "18岁以下")
    private String underEighteenYear;
}
