package com.dr.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @description 业绩排行对象
 * @author luocong
 * @date 2023/10/20 10:10
 * @version 1.0
 */
@ApiModel(value = "NewPerformanceRankVO", description = "业绩排行对象")
@Data
public class NewPerformanceRankVO implements Serializable {

    private static final long serialVersionUID = 2905158483403094072L;

    @ApiModelProperty(value = "设备类型编码")
    private String deviceTypeCode;

    @ApiModelProperty(value = "设备类型名称")
    private String deviceTypeName;

    @ApiModelProperty(value = "业绩排行")
    private Long rank;

    @ApiModelProperty(value = "业绩价值")
    private String performanceValue;

    @ApiModelProperty(value = "标杆业绩价值")
    private String topOnePerValue;

    @ApiModelProperty(value = "门店账号")
    private String shopAccount;

    @ApiModelProperty(value = "门店名称")
    private String shopName;


}
