package com.dr.vo;

import io.swagger.annotations.ApiModel;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description
 * @author luocong
 * @date 2023/11/6 10:04
 * @version 1.0
 */
@ApiModel(value = "SkinProblemContentVO", description = "推荐内容对象")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class SkinProblemContentVO implements Serializable {

    private static final long serialVersionUID = 5540492448805735430L;

    /**
     * 内容标题
     */
    private String contentTitle;

    /**
     * 封面图
     */
    private String coverPicture;

    /**
     * 跳转链接
     */
    private String jumpLinkUrl;

    /**
     * 视觉效果 0:普通,1:高亮
     */
    private Integer view;

    /**
     * 区域配置表id(多个逗号分割)
     */
    private String areaConfigId;

    /**
     * 所属分类id
     */
    private Integer beautyServiceTypeId;

}
