package com.dr.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.List;

/**
 * @description
 * @author luocong
 * @date 2023/11/4 15:36
 * @version 1.0
 */
@ApiModel(value = "SkinProblemRecommendVO", description = "皮肤问题推荐方案")
@AllArgsConstructor
@NoArgsConstructor
@Data
public class SkinProblemRecommendVO implements Serializable {

    private static final long serialVersionUID = -1179193090514776730L;

    @ApiModelProperty(value = "12-黑头,13-粉刺,14-毛孔,15-皱纹,16-色斑")
    private Integer skinFlag;

    @ApiModelProperty(value = "占比")
    private String ratio;

    @ApiModelProperty(value = "推荐内容")
    private List<SkinProblemContentVO> skinProblemContentList;
}
