package com.dr.vo;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

@Data
public class TrackPointVO implements Serializable {

    private static final long serialVersionUID = 297757241565110653L;

    private Asset asset;
    private Location location;

    @Data
    public static class Asset implements Serializable{
        private static final long serialVersionUID = 2475909347203067674L;
        /**
         * 设备 ID，使用用户自定义的值，如 UUID；需要保证
         * 同一设备 id 不变，不同设备 id 不能重复
         */
        private String id;
        /**
         * 设备制造厂商名称
         */
        private String manufacturer;
        /**
         * 设备型号
         */
        private String model;

    }

    @Data
    public static class Location implements Serializable{
        private static final long serialVersionUID = -7178341018301835645L;
        private Position position;
    }

    @Data
    public static class Position implements Serializable{
        private static final long serialVersionUID = -8557592360115977721L;
        /**
         * 定位结果获得的时间戳，单位：毫秒
         */
        private long timestamp;
        /**
         * 坐标点信息
         */
        private Point point;
        /**
         * 定位源信息，可能值有"wifi", "cell","gnss", "ip"
         */
        private String source;
        /**
         * 定位结果的精度值，单位：米
         */
        private double accuracy;
    }

    @NoArgsConstructor
    @AllArgsConstructor
    @Data
    public static class Point implements Serializable {
        private static final long serialVersionUID = -2436048579830394202L;
        /**
         * 经度（gcj02 坐标系）
         */
        private double longitude;
        /**
         * 纬度（gcj02 坐标系）
         */
        private double latitude;
    }
}
