package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-机构、门店数据统计总表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_org_and_shop_data_count")
public class DrOrgAndShopDataCountEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 当天日期
	 */
	private String dailyTime;
	/**
	 * 设备数量
	 */
	private Integer deviceNum;
	/**
	 * 门店所在省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 耗材消耗数量
	 */
	private Integer consumableUseNum;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegion;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
