package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.ibatis.type.JdbcType;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * Created with IntelliJ IDEA.
 *
 * @Auther: zhangyouhui
 * @Date: 2021/03/10/16:11
 * @Description:
 */
@TableName("t_wx_appletuser")
public class WxAppletuserEntity {

    private static final long serialVersionUID = 1L;

    /**
     * 主键
     */
    @TableId(type = IdType.AUTO)
    private Long id;
    /**
     * 微信小程序唯一id
     */
    private String openId;
    /**
     * 用户手机号码
     */
    private String phone;
    /**
     * 用户头像
     */
    private String avatarUrl;
    /**
     * 用户昵称
     */
    private String nickName;
    /***
     * 是否关注了绑定的公众号
     */
    private String officialAccount;
    /**
     * vip等级
     */
    private String vipLevel;
    /**
     * 门店账号
     */
    private String shopAccountNumber;

    /**
     * uuid
     */
    private String unionId;
    /**
     * 地址
     */
    private String address;
    /**
     * 性别
     */
    private String gender;
    /**
     * 分享code
     */
    private String qrcode;
    /**
     * 状态，0，新客，1，更进中，2，已绑定
     */
    private String state;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 销售账号
     */
    private String salesAccountNumber;
    /**
     * 职位
     */
    private String position;
    /**
     * 机构id
     */
    private Integer orgid;

    private String sale;
    /**
     * 喵币数量
     */
    @TableField(jdbcType = JdbcType.DECIMAL)
    private BigDecimal catcoinNum;
    /**
     * 会员等级
     */
    private Integer memberLevel;
    /**
     * 主业务员类型 0:员工 1:业务员
     */
    private Integer salesmanType;
    /**
     * 主业务员id
     */
    private Integer mainSalesmanId;
    /**
     * 长期有效成长值
     */
    private Integer longTermValue;
    /**
     * 用户等级升级日期
     */
    private Date upgradeTime;
    /**
     * 展示门店(0,展示，1，不展示)
     */
    private String displayShop;

    /**
     * 最后访问时间
     */
    private Date lastVisitTime;
    /**
     * 会员权益是否通过报价修改过 0:否 1:是
     */
    public Long getId() {
        return id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getOpenId() {
        return openId;
    }

    public void setOpenId(String openId) {
        this.openId = openId;
    }

    public String getPhone() {
        return phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public String getAvatarUrl() {
        return avatarUrl;
    }

    public void setAvatarUrl(String avatarUrl) {
        this.avatarUrl = avatarUrl;
    }

    public String getNickName() {
        return nickName;
    }

    public void setNickName(String nickName) {
        this.nickName = nickName;
    }

    public String getOfficialAccount() {
        return officialAccount;
    }

    public void setOfficialAccount(String officialAccount) {
        this.officialAccount = officialAccount;
    }

    public String getVipLevel() {
        return vipLevel;
    }

    public void setVipLevel(String vipLevel) {
        this.vipLevel = vipLevel;
    }

    public String getShopAccountNumber() {
        return shopAccountNumber;
    }

    public void setShopAccountNumber(String shopAccountNumber) {
        this.shopAccountNumber = shopAccountNumber;
    }

    public String getUnionId() {
        return unionId;
    }

    public void setUnionId(String unionId) {
        this.unionId = unionId;
    }

    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public String getGender() {
        return gender;
    }

    public void setGender(String gender) {
        this.gender = gender;
    }

    public String getQrcode() {
        return qrcode;
    }

    public void setQrcode(String qrcode) {
        this.qrcode = qrcode;
    }

    public String getState() {
        return state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getSalesAccountNumber() {
        return salesAccountNumber;
    }

    public void setSalesAccountNumber(String salesAccountNumber) {
        this.salesAccountNumber = salesAccountNumber;
    }

    public String getPosition() {
        return position;
    }

    public void setPosition(String position) {
        this.position = position;
    }

    public Integer getOrgid() {
        return orgid;
    }

    public void setOrgid(Integer orgid) {
        this.orgid = orgid;
    }

    public String getSale() {
        return sale;
    }

    public void setSale(String sale) {
        this.sale = sale;
    }

    public BigDecimal getCatcoinNum() {
        return catcoinNum;
    }

    public void setCatcoinNum(BigDecimal catcoinNum) {
        this.catcoinNum = catcoinNum;
    }

    public Integer getMemberLevel() {
        return memberLevel;
    }

    public void setMemberLevel(Integer memberLevel) {
        this.memberLevel = memberLevel;
    }

    public Integer getSalesmanType() {
        return salesmanType;
    }

    public void setSalesmanType(Integer salesmanType) {
        this.salesmanType = salesmanType;
    }

    public Integer getMainSalesmanId() {
        return mainSalesmanId;
    }

    public void setMainSalesmanId(Integer mainSalesmanId) {
        this.mainSalesmanId = mainSalesmanId;
    }

    public Integer getLongTermValue() {
        return longTermValue;
    }

    public void setLongTermValue(Integer longTermValue) {
        this.longTermValue = longTermValue;
    }

    public Date getUpgradeTime() {
        return upgradeTime;
    }

    public void setUpgradeTime(Date upgradeTime) {
        this.upgradeTime = upgradeTime;
    }

    public String getDisplayShop() {
        return displayShop;
    }

    public void setDisplayShop(String displayShop) {
        this.displayShop = displayShop;
    }

    public Date getLastVisitTime() {
        return lastVisitTime;
    }

    public void setLastVisitTime(Date lastVisitTime) {
        this.lastVisitTime = lastVisitTime;
    }

    @Override
    public String toString() {
        return "WxAppletuserEntity{" +
                "id=" + id +
                ", openId='" + openId + '\'' +
                ", phone='" + phone + '\'' +
                ", avatarUrl='" + avatarUrl + '\'' +
                ", nickName='" + nickName + '\'' +
                ", officialAccount='" + officialAccount + '\'' +
                ", vipLevel='" + vipLevel + '\'' +
                ", shopAccountNumber='" + shopAccountNumber + '\'' +
                ", unionId='" + unionId + '\'' +
                ", address='" + address + '\'' +
                ", gender='" + gender + '\'' +
                ", qrcode='" + qrcode + '\'' +
                ", state='" + state + '\'' +
                ", createTime=" + createTime +
                ", salesAccountNumber='" + salesAccountNumber + '\'' +
                ", position='" + position + '\'' +
                ", orgid=" + orgid +
                ", sale='" + sale + '\'' +
                ", catcoinNum=" + catcoinNum +
                ", memberLevel=" + memberLevel +
                ", salesmanType=" + salesmanType +
                ", mainSalesmanId=" + mainSalesmanId +
                ", longTermValue=" + longTermValue +
                ", upgradeTime=" + upgradeTime +
                ", displayShop='" + displayShop + '\'' +
                ", lastVisitTime=" + lastVisitTime +
                '}';
    }
}
