package com.dr.util;


import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.redis.core.StringRedisTemplate;

import java.io.Serializable;

/**
 * Created with IntelliJ IDEA.
 *
 * @Auther: zhangyouhui
 * @Date: 2021/03/08/18:12
 * @Description: 消息返回工具类
 */
@Slf4j
public class Result<T> implements Serializable {
    private static final long serialVersionUID = 1L;
    /**
     * 编码：0表示成功，其他值表示失败
     */
    private int code = 0;
    /**
     * 消息内容
     */
    private String msg = "success";
    /**
     * 响应数据
     */
    private T data;

    private String token;

    public static long getSerialVersionUID() {
        return serialVersionUID;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Result<T> ok(T data) {
        this.setCode(0);
        this.setData(data);
        return this;
    }

    public boolean success(){
        return code == 0;
    }

    public Result<T> error(int code, String msg) {
        this.code = code;
        this.msg = msg;
        return this;
    }


    /*public Result<T> errorByLanguage(int code, int language, StringRedisTemplate stringRedisTemplate) {
        this.code = code;
        Boolean lanFlag = stringRedisTemplate.opsForHash().hasKey(LDMConstant.LANGUAGE_LIST + language, String.valueOf(code));
        if(Boolean.TRUE.equals(lanFlag)){
            Object lanMsg = stringRedisTemplate.opsForHash().get(LDMConstant.LANGUAGE_LIST + language, String.valueOf(code));
            if(null != lanMsg && StringUtils.isNotBlank(lanMsg.toString())){
                this.msg = lanMsg.toString();
            }
        }else {
            log.error("---------语言不存在---------code:{}------>language{}", code, language);
            throw new BusinessRuntimeException(11001, "language error");
        }
        return this;
    }*/


    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getMsg() {
        return msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return data;
    }

    public void setData(T data) {
        this.data = data;
    }
}
