package com.dr.config;

import org.springframework.amqp.core.*;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import java.util.HashMap;
import java.util.Map;

@Configuration
public class RabbitMqConfig {

    @Bean
    public RabbitTemplate rabbitTemplate(ConnectionFactory connectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(connectionFactory);
        rabbitTemplate.setMessageConverter(new Jackson2JsonMessageConverter());
        return rabbitTemplate;
    }

    @Bean
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        factory.setConnectionFactory(connectionFactory);
        factory.setMessageConverter(new Jackson2JsonMessageConverter());
        return factory;
    }

    /**********************************用户下单后确定代理商门店绑定关系****************************************/
    private final static String PROXY_SHOP_QUEUE = "proxyShopQueue";
    private final static String PROXY_SHOP_KEY = "proxyShopKey";
    private final static String PROXY_SHOP_EXCHANGE = "proxyShopExchange";

    public static String getProxyShopKey() {
        return PROXY_SHOP_KEY;
    }
    public static String getProxyShopExchange() {
        return PROXY_SHOP_EXCHANGE;
    }

    @Bean
    public Queue proxyShopQueue() {
        return new Queue(PROXY_SHOP_QUEUE,true);
    }

    @Bean
    public DirectExchange proxyShopExchange() {
        return new DirectExchange(PROXY_SHOP_EXCHANGE, true, false);
    }

    @Bean
    public Binding bindProxyShopExchangeDirect() {
        return BindingBuilder.bind(proxyShopQueue()).to(proxyShopExchange()).with(PROXY_SHOP_KEY);
    }
    /**********************************用户下单后确定代理商门店绑定关系****************************************/


    /**********************************用户购买指定商品开通VIP****************************************/
    private final static String USER_VIP_QUEUE = "userVipQueue";
    private final static String USER_VIP_KEY = "userVipKey";
    private final static String USER_VIP_EXCHANGE = "userVipExchange";

    public static String getUserVipKey() {
        return USER_VIP_KEY;
    }
    public static String getUserVipExchange() {
        return USER_VIP_EXCHANGE;
    }

    @Bean
    public Queue userVipQueue() {
        return new Queue(USER_VIP_QUEUE,true);
    }
    @Bean
    public DirectExchange userVipExchange() {
        return new DirectExchange(USER_VIP_EXCHANGE,true, false);
    }
    @Bean
    public Binding bindUserVipExchangeDirect() {
        return BindingBuilder.bind(userVipQueue()).to(userVipExchange()).with(USER_VIP_KEY);
    }
    /**********************************用户购买指定商品开通VIP****************************************/


    /**********************************修改指定时间未审核的报价的状态****************************************/
    private final static String COMMODITY_QUOTATION_QUEUE = "commodityQuotationQueue";
    private final static String COMMODITY_QUOTATION_KEY = "commodityQuotationKey";
    private final static String COMMODITY_QUOTATION_EXCHANGE = "commodityQuotationExchange";

    public static String getCommodityQuotationKey() {
        return COMMODITY_QUOTATION_KEY;
    }
    public static String getCommodityQuotationExchange() {
        return COMMODITY_QUOTATION_EXCHANGE;
    }

    @Bean
    public Queue commodityQuotationQueue() {
        return new Queue(COMMODITY_QUOTATION_QUEUE,true);
    }
    @Bean
    public CustomExchange commodityQuotationExchange() {
        Map<String, Object> args = new HashMap<>(2);
        args.put("x-delayed-type", "direct");
        return new CustomExchange(COMMODITY_QUOTATION_EXCHANGE, "x-delayed-message", true, false, args);
    }

    @Bean
    public Binding bindCommodityQuotationDelay() {
        return BindingBuilder.bind(commodityQuotationQueue()).to(commodityQuotationExchange()).with(COMMODITY_QUOTATION_KEY).noargs();
    }
    /**********************************修改指定时间未审核的报价的状态****************************************/


    /**********************************苗医生相关数据推送****************************************/
    private final static String MYS_DATA_QUEUE = "reSyncDataQueue";
    private final static String MYS_DATA_KEY = "mysDataKey";
    private final static String MYS_DATA_EXCHANGE = "mysDataExchange";

    public static String getMysDataKey() {
        return MYS_DATA_KEY;
    }
    public static String getMysDataExchange() {
        return MYS_DATA_EXCHANGE;
    }

    @Bean
    public Queue mysDataQueue() {
        return new Queue(MYS_DATA_QUEUE,true);
    }

    @Bean
    public CustomExchange mysDataExchange() {
        Map<String, Object> args = new HashMap<>(2);
        args.put("x-delayed-type", "direct");
        return new CustomExchange(MYS_DATA_EXCHANGE, "x-delayed-message", true, false, args);
    }

    @Bean
    public Binding mysDataDelay() {
        return BindingBuilder.bind(mysDataQueue()).to(mysDataExchange()).with(MYS_DATA_KEY).noargs();
    }
    /**********************************苗医生相关数据推送****************************************/

    /**********************************数据板块统计相关数据推送****************************************/
    public static final String SYNC_SKIN_PROBLEM_DATA_QUEUE = "syncSkinProblemDataQueue";
    public static final String SYNC_SKIN_PROBLEM_DATA_KEY = "syncSkinProblemDatakey";
    public static final String SYNC_SKIN_PROBLEM_DATA_EXCHANGE = "syncSkinProblemDataExchange";
    public static final String SYNC_NEW_SKIN_PROBLEM_DATA_EXCHANGE = "syncNewSkinProblemDataExchange";
    public static final String SYNC_NEW_SKIN_PROBLEM_DATA_KEY = "syncNewSkinProblemDatakey";
    public static final String SYNC_NEW_SKIN_PROBLEM_DATA_QUEUE = "syncNewSkinProblemDataQueue";
    //门店数据同步
    public static final String SYNC_NEW_ORG_AND_SHOP_KEY = "syncNewOrgAndShopKey";
    public static final String SYNC_NEW_ORG_AND_SHOP_QUEUE = "syncNewOrgAndShopQueue";
    public static final String SYNC_NEW_ORG_AND_SHOP_EXCHANGE = "syncNewOrgAndShopExchange";

    @Bean
    public Queue syncSkinProblemDataQueue() {
        return new Queue(SYNC_SKIN_PROBLEM_DATA_QUEUE,true);
    }

    @Bean
    public DirectExchange syncSkinProblemDataExchange() {

        return new DirectExchange(SYNC_SKIN_PROBLEM_DATA_EXCHANGE,true,false);
    }

    @Bean
    public Binding syncSkinProblemDatakeyDelay() {
        return BindingBuilder.bind(syncSkinProblemDataQueue()).to(syncSkinProblemDataExchange()).with(SYNC_SKIN_PROBLEM_DATA_KEY);
    }

    @Bean
    public DirectExchange syncNewSkinProblemDataExchange() {

        return new DirectExchange(SYNC_NEW_SKIN_PROBLEM_DATA_EXCHANGE,true,false);
    }

    /**
     * 同步物联网数据队列
     * @return
     */
    @Bean
    public Queue syncNewSkinProblemDataQueue(){
        return new Queue(SYNC_NEW_SKIN_PROBLEM_DATA_QUEUE,true);
    }

    @Bean
    public Binding syncNewSkinProblemDatakeyDelay() {
        return BindingBuilder.bind(syncNewSkinProblemDataQueue()).to(syncNewSkinProblemDataExchange()).with(SYNC_NEW_SKIN_PROBLEM_DATA_KEY);
    }

    /**
     * 同步物联网数据交换机
     * @return
     */
    @Bean
    DirectExchange syncNewOrgAndShopExchange(){
        return new DirectExchange(SYNC_NEW_ORG_AND_SHOP_EXCHANGE,true,false);
    }
    /**
     * 同步物联网数据队列
     * @return
     */
    @Bean
    public Queue syncNewOrgAndShopQueue(){
        return new Queue(SYNC_NEW_ORG_AND_SHOP_QUEUE,true);
    }
    /**
     * 同步物联网数据队列绑定
     * @return
     */
    @Bean
    Binding syncNewOrgAndShopKey(){
        return BindingBuilder.bind(syncNewOrgAndShopQueue()).to(syncNewOrgAndShopExchange()).with(SYNC_NEW_ORG_AND_SHOP_KEY);
    }
    /**********************************数据板块统计相关数据推送****************************************/


    /**********************************数据板块下载中心****************************************/
    public static final String SYNC_DR_DOWNLOAD_CENTER_KEY = "syncDRDownloadCenterKey";

    public static final String SYNC_DR_DOWNLOAD_CENTER_QUEUE = "syncDRDownloadCenterQueue";

    public static final String SYNC_DR_DOWNLOAD_CENTER_EXCHANGE = "syncDRDownloadCenterExchange";

    /**
     * 交换机绑定
     */
    @Bean
    DirectExchange syncDRDownloadCenterExchange(){
        return new DirectExchange(SYNC_DR_DOWNLOAD_CENTER_EXCHANGE,true,false);
    }
    /**
     * 队列绑定
     */
    @Bean
    public Queue syncDRDownloadCenterQueue(){
        return new Queue(SYNC_DR_DOWNLOAD_CENTER_QUEUE,true);
    }
    /**
     * 同步物联网数据队列绑定
     */
    @Bean
    Binding syncDRDownloadCenterKey(){
        return BindingBuilder.bind(syncDRDownloadCenterQueue()).to(syncDRDownloadCenterExchange()).with(SYNC_DR_DOWNLOAD_CENTER_KEY);
    }
    /**********************************数据板块下载中心****************************************/


}

