package com.dr.controller;

import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dr.service.IAreaConfigService;
import com.dr.util.Result;
import com.dr.vo.CommonUtilVO;
import com.dr.entity.AreaConfigEntity;
import com.dr.mapper.AreaConfigMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.List;

/**
 * @description
 * @author luocong
 * @date 2023/10/16 14:17
 * @version 1.0
 */
@RequestMapping("/djmaftersales/areaConfig")
@RestController
public class AreaConfigController extends BaseController {

    @Autowired
    private IAreaConfigService areaConfigService;

    /**
     * 获取城市区域，如华南，华东
     *
     * @return 城市级别
     */
    @GetMapping("/getRegionList")
    public Result<List<CommonUtilVO>> getRegionList() {
        List<AreaConfigEntity> list = this.areaConfigService.getRegionList();
        List<CommonUtilVO> commonUtilVOList = new ArrayList<>();
        list.forEach(t -> {
            CommonUtilVO commonUtilVO = new CommonUtilVO();
            commonUtilVO.setId(t.getId());
            commonUtilVO.setName(t.getAreaConfigName());
            commonUtilVOList.add(commonUtilVO);
        });
        return new Result<List<CommonUtilVO>>().ok(commonUtilVOList);
    }

    /**
     * 获取城市区域，一线，二线
     *
     * @return 城市级别
     */
    @GetMapping("/getLineCityCode")
    public Result<List<CommonUtilVO>> getLineCityCode() {
        List<AreaConfigEntity> list = this.areaConfigService.getLineCityCode();
        List<CommonUtilVO> commonUtilVOList = new ArrayList<>();
        list.forEach(t -> {
            CommonUtilVO commonUtilVO = new CommonUtilVO();
            commonUtilVO.setId(t.getId());
            commonUtilVO.setName(t.getAreaConfigName());
            commonUtilVOList.add(commonUtilVO);
        });
        return new Result<List<CommonUtilVO>>().ok(commonUtilVOList);
    }

}
