package com.dr.entity;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 数据统计-客户使用日志日表
 * @author luocong
 * @date 2024-08-06 15:59:16
 * @version 1.0
 */
@Data
@TableName("dr_client_use_logs_by_day")
public class DrClientUseLogsByDayEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	/**
	 * id
	 */
	@TableId(type = IdType.AUTO)
	private Long id;
	/**
	 * 当天日期
	 */
	private String dailyTime;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 单次到店客户数
	 */
	private Integer onceArriveClientNum;
	/**
	 * 多次到店客户数
	 */
	private Integer moreArriveClientNum;

}
