package com.dr.entity;

import lombok.Data;

import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * @description 数据统计-产品推广曝光数据日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@Data
public class DrProductRecommendByDayEntity implements Serializable {
	private static final long serialVersionUID = -1634193320442126288L;

	/**
	 * id
	 */
	private Long id;
	/**
	 * 门店名称
	 */
	private String shopName;
	/**
	 * 门店账号
	 */
	private String shopAccount;
	/**
	 * 机构名称
	 */
	private String orgName;
	/**
	 * 机构账号
	 */
	private String orgAccount;
	/**
	 * 当天日期
	 */
	private LocalDate dailyTime;
	/**
	 * 产品名称
	 */
	private String goodsName;
	/**
	 * 推荐量
	 */
	private Integer recommendNum;
	/**
	 * 产品id
	 */
	private Long goodsId;
	/**
	 * 是否删除（0-否，1是，默认0）
	 */
	private Integer deleted;
	/**
	 * 创建人名字
	 */
	private String createUserName;
	/**
	 * 创建时间
	 */
	private LocalDateTime createTime;
	/**
	 * 修改时间
	 */
	private LocalDateTime updateTime;
	/**
	 * 修改人名字
	 */
	private String updateUserName;
	/**
	 * 门店省行政名称
	 */
	private String shopProvinceName;
	/**
	 * 门店市行政名称
	 */
	private String shopCityName;
	/**
	 * 门店区行政名称
	 */
	private String shopRegionName;
	/**
	 * 门店详细地址
	 */
	private String shopAddress;

}
