package com.dr.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.dr.entity.AreaConfigEntity;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description 城市地区分配表
 * @author luocong
 * @date 2023-10-16 11:43
 * @version 1.0
 */
@Mapper
public interface AreaConfigMapper extends BaseMapper<AreaConfigEntity> {

    /**
     * 查询地区
     *
     * @param cityId 城市id
     * @return AreaConfigEntity
     */
    AreaConfigEntity selectLineCity(@Param("cityId") Integer cityId);

    /**
     * 根据区域配置地区查询市区id
     *
     * @param regionId 区域配置表id
     * @return 市区id
     */
    List<Integer> selectAreaIdListByConf(@Param("regionId") Long regionId);
}
