package com.dr.mapper;

import com.dr.entity.DrClientAgeDistributeByDayEntity;
import com.dr.vo.NewAgeDistributionVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Update;

import java.util.List;

/**
 * @description 数据统计-客户年龄信息分布日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@Mapper
public interface DrClientAgeDistributeByDayMapper {


    /**
     * 批量插入
     *
     * @param list list
     */
    void saveBatch(List<DrClientAgeDistributeByDayEntity> list);

    /**
     * 年龄分布查询
     *
     * @param oAccount 机构账号
     * @param shopAccounts 门店账号数据集合
     * @return List<NewAgeDistributionVO>
     */
    List<NewAgeDistributionVO> list(@Param("oAccount") String oAccount, @Param("mAccounts") String[] shopAccounts);

    @Update("truncate table dr_client_age_distribute_by_day")
    void truncateTable();
}
