package com.dr.mapper;

import com.dr.entity.*;
import com.dr.vo.NewArriveShopRankVO;
import com.dr.vo.NewCheckCaseRankVO;
import com.dr.vo.NewClientDistributionVO;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * @description 数据统计-顾客案例新增明细日表
 * @author luocong
 * @date 2024-07-25 11:31:43
 * @version 1.0
 */
@Mapper
public interface DrNewAddClientAndCaseByDayMapper {

    void saveBatch(List<DrNewAddClientAndCaseByDayEntity> list);

    /**
     * 获取最后一条数据
     *
     * @param memberAccount 门店账号
     * @return DrNewAddClientAndCaseByDayEntity
     */
    DrNewAddClientAndCaseByDayEntity getLastOne(@Param("memberAccount") String memberAccount);

    /**
     * 查询客户与案例数据
     *
     * @param oAccount 机构账号
     * @param sAccount 门店账号
     * @return List<DrNewAddClientAndCaseByDayEntity>
     */
    DrNewAddClientAndCaseByDayEntity selectClientAndCase(@Param("oAccount") String oAccount, @Param("sAccount") String sAccount, @Param("time") String time);

    /**
     * 检测排行
     *
     * @param time 日期
     * @param oAccount 机构账号
     * @param pageNum 页数
     * @param pageSize 条数
     * @return List<NewCheckCaseRankVO>
     */
    List<NewCheckCaseRankVO> selectCheckCaseRank(@Param("time") String time, @Param("oAccount") String oAccount,
                                                 @Param("pageNum") Integer pageNum, @Param("pageSize") Integer pageSize);

    /**
     * 查询到店排行
     *
     * @param time time
     * @param oAccount 机构账号
     * @param pageNum 页数
     * @param pageSize 条数
     * @return List<NewArriveShopRankVO>
     */
    List<NewArriveShopRankVO> selectArriveShopRank(@Param("time") String time, @Param("oAccount") String oAccount,
                                                   @Param("pageNum") Integer pageNum, @Param("pageSize") Integer pageSize);

    /**
     * 客户地域分布
     *
     * @param oAccount 机构账号
     * @param pageNum 页数
     * @param pageSize 条数
     * @param time 时间
     * @return List<NewClientDistributionVO>
     */
    List<NewClientDistributionVO> selectClientDistribution(@Param("oAccount") String oAccount, @Param("pageNum") Integer pageNum,
                                                           @Param("pageSize") Integer pageSize, @Param("time") String time);

    /**
     * 统计检测排行数量
     *
     * @param time 时间
     * @param oAccount 机构账号
     * @return 数量
     */
    Long countCheckCaseRank(@Param("time") String time, @Param("oAccount") String oAccount);

    /**
     * 统计到店排行
     * @param time
     * @param oAccount
     * @return 数量
     */
    Long countArriveShopRank(String time, String oAccount);

    /**
     * 统计客户地域分布数量
     *
     * @param oAccount 机构账号
     * @param time 时间
     * @return 数量
     */
    Long countClientDistribution(String oAccount, String time);

    /**
     * 删除小于id的表数据
     *
     * @param id id
     */
    void removeByLessId(@Param("id") Long id);
}
