package com.dr.service.impl;


import com.alibaba.fastjson.JSON;
import com.dr.config.ConstantConfig;
import com.dr.dto.MemberProductRecommendDTO;
import com.dr.dto.OrgProductRecommendRedisDTO;
import com.dr.dto.ProductRecommendDTO;
import com.dr.util.NewDateUtil;
import com.dr.mapper.DrClientAgeDistributeByDayMapper;
import com.dr.mapper.DrNewAddClientAndCaseByDayMapper;
import com.dr.mapper.DrProductRecommendByDayMapper;
import com.dr.service.INewDataReportService;
import com.dr.vo.*;
import com.dr.entity.*;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @description
 * @author luocong
 * @date 2024/8/19 17:50
 * @version 1.0
 */
@Service
public class NewDataReportServiceImpl implements INewDataReportService {

    @Autowired
    private DrNewAddClientAndCaseByDayMapper drNewAddClientAndCaseByDayMapper;
    @Autowired
    private DrProductRecommendByDayMapper drProductRecommendByDayMapper;
    @Autowired
    private DrClientAgeDistributeByDayMapper drClientAgeDistributeByDayMapper;

    @Autowired
    private RedisTemplate<String, String> redisTemplate;

    @Override
    public ApiTemplateVO<NewClientAndCaseGroupVO> countClientAndCase(String oAccount, String mAccount) {
        String time = NewDateUtil.getBeforeTime(1, NewDateUtil.PATTERN_A, 1);
        DrNewAddClientAndCaseByDayEntity drNewAddClientAndCaseByDayEntity = this.drNewAddClientAndCaseByDayMapper.selectClientAndCase(oAccount, mAccount, time);
        ApiTemplateVO<NewClientAndCaseGroupVO> apiTemplateVO = new ApiTemplateVO<>();
        NewClientAndCaseGroupVO newClientAndCaseGroupVO = new NewClientAndCaseGroupVO();
        if (null == drNewAddClientAndCaseByDayEntity) {
            newClientAndCaseGroupVO = new NewClientAndCaseGroupVO(0L, 0L, 0L, 0L, 0L, 0L);
        } else {
            newClientAndCaseGroupVO.setCaseGroupNum(drNewAddClientAndCaseByDayEntity.getCaseGroupNum().longValue());
            newClientAndCaseGroupVO.setClientNum(drNewAddClientAndCaseByDayEntity.getClientNum().longValue());
            newClientAndCaseGroupVO.setAddClientByYesterday(drNewAddClientAndCaseByDayEntity.getAddClientNum().longValue());
            newClientAndCaseGroupVO.setAddCaseByYesterday(drNewAddClientAndCaseByDayEntity.getAddClientNum().longValue());
            newClientAndCaseGroupVO.setOnceArriveShopClientNum(drNewAddClientAndCaseByDayEntity.getOnceArriveClientNum().longValue());
            newClientAndCaseGroupVO.setMoreArriveShopClientNum(drNewAddClientAndCaseByDayEntity.getMoreArriveClientNum().longValue());
        }
        return apiTemplateVO.SUCCESS(newClientAndCaseGroupVO);
    }

    @Override
    public ApiTemplateVO<List<NewCheckCaseRankVO>> selectCheckCaseRank(String time, String oAccount, Integer pageNum, Integer pageSize) {
        ApiTemplateVO<List<NewCheckCaseRankVO>> apiTemplateVO = new ApiTemplateVO<>();
        List<NewCheckCaseRankVO> list = this.drNewAddClientAndCaseByDayMapper.selectCheckCaseRank(time, oAccount, pageNum, pageSize);
        Long count = this.drNewAddClientAndCaseByDayMapper.countCheckCaseRank(time, oAccount);
        if (CollectionUtils.isEmpty(list)) {
            apiTemplateVO.setTotal(0L);
            return apiTemplateVO.SUCCESS(new ArrayList<>());
        }
        apiTemplateVO.setTotal(count);
        return apiTemplateVO.SUCCESS(list);
    }

    @Override
    public ApiTemplateVO<List<NewProductRecommendVO>> productRecommend(String oAccount, String mAccount, Integer pageSize, Integer pageNum) {
        ApiTemplateVO<List<NewProductRecommendVO>> apiTemplate = new ApiTemplateVO<>();

        if (StringUtils.isBlank(oAccount)) {
            return apiTemplate.NULL();
        }

        String result = redisTemplate.opsForValue().get(ConstantConfig.BASE_REDIS_KEY
                + ConstantConfig.PRODUCT_REDIS_KEY + oAccount);

        List<NewProductRecommendVO> productRecommendResultList = new ArrayList<>();
        if (StringUtils.isNotBlank(result)) {
            OrgProductRecommendRedisDTO orgProductRecommendRedisDTO = JSON.parseObject(result, OrgProductRecommendRedisDTO.class);
            if (null != orgProductRecommendRedisDTO) {
                if (StringUtils.isNotBlank(mAccount)) {
                    MemberProductRecommendDTO memberProductRecommendDTO = orgProductRecommendRedisDTO.getMemberProductRecommendList().stream().filter(t -> StringUtils.isNotBlank(t.getMAccount()) && t.getMAccount().equals(mAccount)).findAny().orElse(null);
                    if (null != memberProductRecommendDTO) {
                        for (ProductRecommendDTO productRecommendDTO : memberProductRecommendDTO.getProductRecommendList()) {
                            NewProductRecommendVO productRecommendResultVO = new NewProductRecommendVO();
                            productRecommendResultVO.setProductName(productRecommendDTO.getGoodsName());
                            productRecommendResultVO.setRecommendNum(productRecommendDTO.getRecommendNum());
                            productRecommendResultList.add(productRecommendResultVO);
                        }
                    }
                    apiTemplate.setTotal((long) productRecommendResultList.size());
                    if (null != pageSize && null != pageNum && pageNum > 0) {
                        productRecommendResultList = productRecommendResultList.stream().skip((long) pageSize * (pageNum - 1)).limit(pageSize)
                                .sorted(Comparator.comparing(NewProductRecommendVO::getRecommendNum).reversed()).collect(Collectors.toList());
                    }
                    apiTemplate.setCode(200);
                    return apiTemplate.SUCCESS(productRecommendResultList);
                }
                for (ProductRecommendDTO productRecommendDTO : orgProductRecommendRedisDTO.getProductRecommendList()) {
                    NewProductRecommendVO productRecommendResultVO = new NewProductRecommendVO();
                    productRecommendResultVO.setProductName(productRecommendDTO.getGoodsName());
                    productRecommendResultVO.setRecommendNum(productRecommendDTO.getRecommendNum());
                    productRecommendResultList.add(productRecommendResultVO);
                }
            }
        }
        apiTemplate.setTotal((long) productRecommendResultList.size());
        if (null != pageSize && null != pageNum && pageNum > 0) {
            productRecommendResultList = productRecommendResultList.stream().skip((long) pageSize * (pageNum - 1)).limit(pageSize)
                    .sorted(Comparator.comparing(NewProductRecommendVO::getRecommendNum).reversed()).collect(Collectors.toList());
        }
        apiTemplate.setCode(200);
        return apiTemplate.SUCCESS(productRecommendResultList);
    }

    @Override
    public ApiTemplateVO<List<NewProductRecommendVO>> selectProductRecommend(String oAccount, String mAccount, Integer pageNum, Integer pageSize) {
        ApiTemplateVO<List<NewProductRecommendVO>> apiTemplateVO = new ApiTemplateVO<>();
        List<NewProductRecommendVO> list = this.drProductRecommendByDayMapper.selectList(oAccount, mAccount, pageNum, pageSize);
        Long count = this.drProductRecommendByDayMapper.selectCount(oAccount, mAccount);
        if (CollectionUtils.isEmpty(list)) {
            apiTemplateVO.setTotal(0L);
            return apiTemplateVO.SUCCESS(new ArrayList<>());
        }
        apiTemplateVO.setTotal(count);
        return apiTemplateVO.SUCCESS(list);
    }

    @Override
    public ApiTemplateVO<List<NewArriveShopRankVO>> selectArriveShopRank(String time, String oAccount, Integer pageNum, Integer pageSize) {
        ApiTemplateVO<List<NewArriveShopRankVO>> apiTemplateVO = new ApiTemplateVO<>();
        List<NewArriveShopRankVO> list = this.drNewAddClientAndCaseByDayMapper.selectArriveShopRank(time, oAccount, pageNum, pageSize);
        Long count = this.drNewAddClientAndCaseByDayMapper.countArriveShopRank(time, oAccount);
        if (CollectionUtils.isEmpty(list)) {
            apiTemplateVO.setTotal(0L);
            return apiTemplateVO.SUCCESS(new ArrayList<>());
        }
        apiTemplateVO.setTotal(count);
        return apiTemplateVO.SUCCESS(list);
    }

    @Override
    public ApiTemplateVO<List<NewAgeDistributionVO>> selectAgeDistribution(String oAccount, String[] mAccounts) {
        ApiTemplateVO<List<NewAgeDistributionVO>> apiTemplateVO = new ApiTemplateVO<>();
        List<NewAgeDistributionVO> list = this.drClientAgeDistributeByDayMapper.list(oAccount, mAccounts);
        if (CollectionUtils.isEmpty(list)) {
            return apiTemplateVO.SUCCESS(new ArrayList<>());
        }
        return apiTemplateVO.SUCCESS(list);
    }

    @Override
    public ApiTemplateVO<List<NewClientDistributionVO>> selectClientDistribution(String oAccount, Integer pageNum, Integer pageSize) {
        ApiTemplateVO<List<NewClientDistributionVO>> apiTemplateVO = new ApiTemplateVO<>();
        String time = NewDateUtil.getBeforeTime(1, NewDateUtil.PATTERN_A, 1);
        List<NewClientDistributionVO> list = this.drNewAddClientAndCaseByDayMapper.selectClientDistribution(oAccount, pageNum, pageSize, time);
        Long count = this.drNewAddClientAndCaseByDayMapper.countClientDistribution(oAccount, time);
        if (CollectionUtils.isEmpty(list)) {
            apiTemplateVO.setTotal(0L);
            return apiTemplateVO.SUCCESS(new ArrayList<>());
        }
        apiTemplateVO.setTotal(count);
        return apiTemplateVO.SUCCESS(list);
    }

}
