package com.dr.util;

import org.springframework.stereotype.Component;

/**
 * GRPC 响应模板 form Metis/Moreme
 */
@Component
public class ApiTemplate {
    //数据
    private Object data;
    //请求状态0 失败 1 成功
    private Integer sign;
    //提示信息
    private String messages;
    //code业务代码
    private Integer code;

    private Long total;

    /**
     * 请求成功模板
     *
     * @param data 数据实体
     * @return 响应数据模板
     */
    public ApiTemplate setApiTemplate(Object data) {
        this.data = data;
        this.sign = 1;
        this.messages = "请求成功";
        this.code = 200;
        return this;
    }

    /**
     * 失败模板
     *
     * @param messages 失败原因
     * @param code     BusinessCode 业务状态码
     * @return 响应数据模板
     */
    public ApiTemplate setApiTemplate(String messages, Integer code) {
        this.data = null;
        this.sign = 0;
        this.messages = messages;
        this.code = code;
        return this;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Integer getSign() {
        return sign;
    }

    public void setSign(Integer sign) {
        this.sign = sign;
    }

    public String getMessages() {
        return messages;
    }

    public void setMessages(String messages) {
        this.messages = messages;
    }

    public Integer getCode() {
        return code;
    }

    public void setCode(Integer code) {
        this.code = code;
    }

    public Long getTotal() {
        return total;
    }

    public void setTotal(Long total) {
        this.total = total;
    }
}
