package com.dr.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.dr.vo.LocationDataVO;
import com.dr.vo.TrackPointVO;
import lombok.extern.slf4j.Slf4j;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class MapAddressUtil {
    @Resource
    private RedisTemplate redisTemplate;

    private static MapAddressUtil mapAddressUtil;

    private static final Logger logger = LoggerFactory.getLogger(MapAddressUtil.class);

    @PostConstruct
    public void init(){
        mapAddressUtil=this;
        mapAddressUtil.redisTemplate=this.redisTemplate;
    }
    public static Site getAdrres(String longitude, String latitude) {
        Site site = new Site();
        try {
            //解析经纬度
            if(StringUtils.isNotBlank(longitude) && StringUtils.isNotBlank(latitude)){
                String newlongitude = longitude;
                String newlatitude = latitude;
                //精确小数点后三位
                int longitudeIndex = longitude.indexOf(".");
                int latitudeIndex = latitude.indexOf(".");
                if(longitudeIndex != -1){
                    if((longitudeIndex + 5) <= newlongitude.length()){
                        newlongitude = longitude.substring(0,longitudeIndex) + longitude.substring(longitudeIndex,longitudeIndex+5);
                    }
                }
                if(latitudeIndex != -1){
                    if((latitudeIndex + 5) <= newlatitude.length()){
                        newlatitude = latitude.substring(0,latitudeIndex) + latitude.substring(latitudeIndex,latitudeIndex+5);
                    }
                }
                if(mapAddressUtil.redisTemplate.opsForHash().hasKey("site:address",newlongitude + "--" + newlatitude)){
                    site = com.alibaba.fastjson.JSONObject.parseObject(
                            mapAddressUtil.redisTemplate.opsForHash().get("site:address",newlongitude + "--" + newlatitude).toString(),Site.class);
                }else {
                    //使用维智API
                    TrackPointVO.Point point = new TrackPointVO.Point(Double.parseDouble(longitude), Double.parseDouble(latitude));
                    LocationDataVO locationDataVO;
                    //标识
                    boolean flag = false;
                    try {
                        locationDataVO = WeiZhiMapUtil.getGeographyConvert(point);
                        if(null == locationDataVO.getLocation()){
                            flag = true;
                        } else {
                            site.setFormatted_address(locationDataVO.getLocation().getAddress().getName());
                            site.setCountry(locationDataVO.getLocation().getAddress().getContext().get(0).getName());
                            site.setProvince(locationDataVO.getLocation().getAddress().getContext().get(1).getName());
                            site.setCity(locationDataVO.getLocation().getAddress().getContext().get(2).getName());
                            site.setDistrict(locationDataVO.getLocation().getAddress().getContext().get(3).getName());
                            String countryCode = locationDataVO.getLocation().getAddress().getContext().get(0).getCode();
                            if("CN".equals(countryCode)){
                                site.setCountry_code("0");
                            } else {
                                site.setCountry_code(countryCode);
                            }
                            site.setAdcode(locationDataVO.getLocation().getAddress().getContext().get(3).getCode());
                        }
                    } catch (Exception e){
                        flag = true;
                        log.error("-----------------------维智定位失败--------------------{}", e.getMessage(), e);
                    }
                    if(flag){
                        //使用Here验证国外的
                        boolean inChinaFlag = HereMapUtil.isInChina(Double.parseDouble(latitude), Double.parseDouble(longitude));
                        if(!inChinaFlag){
                            Site site1 = HereMapUtil.getGeographyConvert(Double.parseDouble(latitude), Double.parseDouble(longitude));
                            flag = null == site1;
                        }
                        if(flag) {
                            // 使用百度API : 根据经纬度反向解析地址信息
                            Map<String, String> params = new HashMap<String, String>(8);
                            params.put("ak", "2fsU6tsUBrElmrkSHXVBYVUq5vqb14Za");
                            params.put("output", "json");
                            params.put("coordtype", "wgs84ll");
                            params.put("location", latitude + "," + longitude);
                            String url = "http://api.map.baidu.com/reverse_geocoding/v3/";
                            String data = HttpRequest.sendGet(url, params);
                            logger.info("百度地图返回结果---->data----->" + JSON.toJSONString(data));
                            JSONObject object = JSONObject.fromObject(data);
                            if (object != null && object.getInt("status") == 0) {
                                JSONObject result = JSONObject.fromObject(object.get("result"));
                                if (result != null && result.size() > 0 && !"{}".equals(JSON.toJSONString(result))) {
                                    JSONObject addressComponent = JSONObject.fromObject(result.get("addressComponent"));
                                    /*持久化地址对象*/
                                    site.setFormatted_address(String.valueOf(result.get("formatted_address")));
                                    site.setCountry(String.valueOf(addressComponent.get("country")));
                                    site.setProvince(String.valueOf(addressComponent.get("province")));
                                    site.setCity(String.valueOf(addressComponent.get("city")));
                                    site.setDistrict(String.valueOf(addressComponent.get("district")));
                                    site.setCountry_code(String.valueOf(addressComponent.get("country_code")));
                                    site.setAdcode(String.valueOf(addressComponent.get("adcode")));
                                }
                            } else {
                                // 使用天地图API（浏览器端的应用） 根据经纬度反向解析地址信息
                                String tUrl = "http://api.tianditu.gov.cn/geocoder?postStr={'lon':" + longitude + ",'lat':" + latitude + ",'ver':1}&type=geocode&tk=8cc1da8666fa6e682f9d2e255730e382";
                                String tData = HttpUtil.get(tUrl);
                                logger.info("天地图返回结果---tData---->" + JSON.toJSONString(tData));
                                JSONObject tjsonObject = JSONObject.fromObject(tData);
                                Object tstatus = tjsonObject.get("status");
                                JSONObject tresult = JSONObject.fromObject(tjsonObject.get("result"));
                                if (null != tstatus && tstatus.equals("0")) {
                                    JSONObject taddressComponent = JSONObject.fromObject(tresult.get("addressComponent"));

                                    site.setFormatted_address(String.valueOf(tresult.get("formatted_address")));
                                    site.setCountry(String.valueOf(taddressComponent.get("nation")));
                                    site.setProvince(String.valueOf(taddressComponent.get("province")));
                                    site.setCity(String.valueOf(taddressComponent.get("city")));
                                    site.setDistrict(String.valueOf(taddressComponent.get("county")));
                                    site.setCountry_code("0"); // 没有，默认为0
                                    site.setAdcode(String.valueOf(taddressComponent.get("county_code")).substring(3, 9));
                                }
                            }
                        }
                    }

                    if(mapAddressUtil.redisTemplate.hasKey("site:address")){
                        mapAddressUtil.redisTemplate.opsForHash().put("site:address",newlongitude + "--" + newlatitude, com.alibaba.fastjson.JSONObject.toJSONString(site));
                    }else{
                        String jsonString = com.alibaba.fastjson.JSONObject.toJSONString(site);

                        mapAddressUtil.redisTemplate.opsForHash().put("site:address",newlongitude + "--" + newlatitude, jsonString);
                        mapAddressUtil.redisTemplate.expire("site:address", 3,TimeUnit.DAYS);
                    }
                }
            }
        } catch (Exception e) {
            log.error("--------->>>地图解析失败:{}", e.getMessage(), e);
            return null;
        }
        return site;
    }

}
