package com.dr.util;

import com.dr.constant.CodeMsg;
import io.swagger.v3.oas.annotations.media.Schema;
import lombok.Data;

/**
 * @author luocong
 * @since 2023-01-29 14:24:53
 */
@Schema(description = "返回结果对象")
@Data
public class Results<T> {

    @Schema(description = "返回状态码 0-成功,其他-失败")
    private int code;

    @Schema(description = "提示信息")
    private String msg;

    @Schema(description = "token")
    private String token;

    @Schema(description = "响应数据")
    private T data;

    public Results() {
    }

    private Results(T data, String token) {
        this.data = data;
        this.token = token;
        this.code = CodeMsg.SUCCESS.getCode();
        this.msg = CodeMsg.SUCCESS.getMsg();
    }

    private Results(int code, String msg) {
        this.code = code;
        this.msg = msg;
    }

    private Results(T data) {
        this.data = data;
        this.code = CodeMsg.SUCCESS.getCode();
        this.msg = CodeMsg.SUCCESS.getMsg();
    }

    private Results(int code, String msg, String token) {
        this.token = token;
        this.code = CodeMsg.SUCCESS.getCode();
        this.msg = CodeMsg.SUCCESS.getMsg();
    }

    private Results(CodeMsg codeMsg, String token) {
        if (codeMsg != null) {
            this.code = codeMsg.getCode();
            this.msg = codeMsg.getMsg();
            this.token = token;
        }
    }

    private Results(CodeMsg codeMsg) {
        if (codeMsg != null) {
            this.code = codeMsg.getCode();
            this.msg = codeMsg.getMsg();
        }
    }

    /**
     * 成功时候的调用
     *
     * @return <T>
     */
    public static <T> Results<T> success(T data) {
        return new Results<T>(data);
    }

    /**
     * 成功时候的调用
     *
     * @return <T>
     */
    public static <T> Results<T> success() {
        return new Results<T>((T) null);
    }

    /**
     * 成功时候的调用
     *
     * @return <T>
     */
    public static <T> Results<T> success(T data, String token) {
        return new Results<T>(data, token);
    }

    /**
     * 失败时候的调用
     *
     * @return <T>
     */
    public static <T> Results<T> error(CodeMsg codeMsg, String token) {
        return new Results<T>(codeMsg, token);
    }

    /**
     * 失败时候的调用
     *
     * @return <T>
     */
    public static <T> Results<T> error(CodeMsg codeMsg) {
        return new Results<T>(codeMsg);
    }

    public static <T> Results<T> error(int code, String msg) {
        return new Results<T>(code, msg);
    }

}