package com.dr.util;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson2.JSON;
import com.dr.vo.LocationDataVO;
import com.dr.vo.TrackPointVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.time.LocalDateTime;
import java.time.ZoneOffset;

/**
 * @description
 * @author luocong
 * @date 2024/8/23 10:08
 * @version 1.0
 */
@Slf4j
@Component
public class WeiZhiMapUtil {

    private static final String AK = "JznC2c8X3KRZCiQ72QBPDgQs2QGflBIm";

    public static LocationDataVO getGeographyConvert(TrackPointVO.Point point) {
        String url = "https://api.newayz.com/location/hub/v1/track_points?access_key=" + AK;
        TrackPointVO trackPointVO = new TrackPointVO();
        TrackPointVO.Location location = new TrackPointVO.Location();
        TrackPointVO.Position position = new TrackPointVO.Position();
        position.setPoint(point);
        position.setTimestamp(LocalDateTime.now().toInstant(ZoneOffset.UTC).toEpochMilli());
        location.setPosition(position);
        trackPointVO.setLocation(location);
        trackPointVO.setAsset(new TrackPointVO.Asset());
        String body = HttpUtil.post(url, JSON.toJSONString(trackPointVO));
        log.info("----------->>>维智地图返回接口信息:{}", body);
        return JSON.parseObject(body, LocationDataVO.class);
    }

}
