package com.dr.vo;

import lombok.AllArgsConstructor;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

@AllArgsConstructor
@Data
public class HereMapGRevGeoVO implements Serializable {
    
    private static final long serialVersionUID = -4578433998945260527L;
    
    private List<Item> items;
    
    @AllArgsConstructor
    @Data
    public static class Item implements Serializable{
        private static final long serialVersionUID = 2246921871764953018L;
        private String title;
        private String id;
        private String resultType;
        private Address address;
        private Position position;
        private List<Access> access;
        private int distance;
        private List<Category> categories;
    }

    @AllArgsConstructor
    @Data
    public static class Address implements Serializable{
        private static final long serialVersionUID = -6704979985713248123L;
        private String label;
        private String countryCode;
        private String countryName;
        private String stateCode;
        private String state;
        private String county;
        private String city;
        private String postalCode;

    }
    
    @AllArgsConstructor
    @Data
    public static class Position implements Serializable{
        private static final long serialVersionUID = -1254799162962571434L;
        private double lat;
        private double lng;
    }

    @AllArgsConstructor
    @Data
    public static class Access implements Serializable{
        private static final long serialVersionUID = 9061870958673648800L;
        private double lat;
        private double lng;

    }
    
    @AllArgsConstructor
    @Data
    public static class Category implements Serializable{
        private static final long serialVersionUID = -2341192791209099188L;
        private String id;
        private String name;
        private boolean primary;

    }
}
