package com.dr.vo;

import lombok.Data;

import java.io.Serializable;
import java.util.List;

@Data
public class LocationDataVO implements Serializable {
    
    private static final long serialVersionUID = 3910213702771616315L;
    /**
     * 随机生成定位请求的 UUID
     */
    private String id;
    /**
     * 设备 ID，根据请求的设备 ID
     */
    private String asset;
    /**
     * 定位的结构化位置信息
     */
    private Location location;
    
    @Data
    public static class Location implements Serializable{
        private static final long serialVersionUID = 1246440428711930711L;
        /**
         * 定位请求的时间戳，单位：毫
         */
        private long timestamp;
        /**
         * 结构化地址信息
         */
        private Address address;
        /**
         * 定位 POI 信息
         */
        private Place place;
        /**
         * 定位的坐标信息
         */
        private Position position;
    }

    @Data
    public static class Address implements Serializable{
        private static final long serialVersionUID = -5665512468535923300L;
        /**
         * 当前定位地址的格式化全称
         */
        private String name;
        /**
         * 定位地址所能达到的层级，参考列表见附录
         */
        private int level;
        /**
         * 格式化地址的组成部分
         */
        private List<Context> context;
    }

    @Data
    public static class Context implements Serializable{
        
        private static final long serialVersionUID = -5183971760425346742L;
        /**
         * 格式化地址层级对应的代码
         */
        private String code;
        /**
         * 格式化地址层级对应的名称
         */
        private String name;
        /**
         * 格式化地址层级对应的类型，可能的值包 括："Country"，
         * "Province"，"City"，"District"，"Township"，"Road"，
         * "Housenumber"，"Boundingarea"，"Building"
         */
        private String type;
    }

    @Data
    public static class Place implements Serializable{
        
        private static final long serialVersionUID = -4630626617135132152L;
        /**
         * 当前 place 的 placeId
         */
        private String id;
        /**
         * 对应的 POI 名称
         */
        private String name;
        /**
         * 当前场景的属性信息，例如："Entity" 等
         */
        private String type;
        /**
         * 如果对应 POI 存在类型分类，则提供类别信息
         */
        private List<Category> categories;
    }

    @Data
    public static class Category implements Serializable{
        
        private static final long serialVersionUID = 970156158505739820L;
        /**
         * 分类对应的 id
         */
        private long id;
        /**
         * 分类对应的名称
         */
        private String name;
    }

    @Data
    public static class Position implements Serializable{
        
        private static final long serialVersionUID = -1853474231354355240L;
        /**
         * 定位结果获得的时间戳，单位：毫秒
         */
        private long timestamp;
        /**
         * 坐标点信息
         */
        private Point point;
        /**
         * 定位源信息，可能值有"wifi", "cell","gnss", "ip"
         */
        private String spatialReference;
        /**
         * 定位结果的精度值，单位：米
         */
        private String source;
        /**
         * 坐标点所属的空间坐标系，默认 "gcj02"
         */
        private double confidence;
        /**
         * 定位结果的置信值
         */
        private double accuracy;
    }

    @Data
    public static class Point implements Serializable{
        
        private static final long serialVersionUID = -46702166542529658L;
        /**
         * 经度
         */
        private double longitude;
        /**
         * 纬度
         */
        private double latitude;
        /**
         * 高程信息，单位：米
         */
        private double altitude;
    }
}
