package com.dr.vo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @description 客户与案例数据对象
 * @author luocong
 * @date 2023/12/2 14:06
 * @version 1.0
 */
@ApiModel(value = "NewClientAndCaseGroupVO", description = "客户与案例数据对象")
@Data
@NoArgsConstructor
@AllArgsConstructor
public class NewClientAndCaseGroupVO implements Serializable {

    private static final long serialVersionUID = -3357931515145301514L;

    @ApiModelProperty(value = "案例总数")
    private Long caseGroupNum;

    @ApiModelProperty(value = "昨日新增案例数")
    private Long addCaseByYesterday;

    @ApiModelProperty(value = "客户总数")
    private Long clientNum;

    @ApiModelProperty(value = "单次到店客户数")
    private Long onceArriveShopClientNum;

    @ApiModelProperty(value = "多次到店客户数")
    private Long moreArriveShopClientNum;

    @ApiModelProperty(value = "昨日新增客户数")
    private Long addClientByYesterday;

}
