package com.dr.vo;

import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.time.LocalDateTime;

/**
 * @description 统计设备与耗材消耗数据
 * @author luocong
 * @date 2023/12/2 14:06
 * @version 1.0
 */
@ApiModel(value = "NewDeviceRealTimeVO", description = "设备实时数据对象")
@Data
public class NewDeviceRealTimeVO implements Serializable {

    private static final long serialVersionUID = -7775120696707315537L;

    @JsonFormat(pattern = "yyyy/MM/dd HH:mm", timezone = "GMT+8")
    @ApiModelProperty(value = "开始时间 ")
    private LocalDateTime startTime;

    @ApiModelProperty(value = "仪器名称")
    private String deviceTypeName;

    @ApiModelProperty(value = "操作人员")
    private String employeeName;

    @ApiModelProperty(value = "顾客名称")
    private String clientName;

    @ApiModelProperty(value = "耗材名称")
    private String consumableTypeName;

    @ApiModelProperty(value = "所属门店")
    private String shopName;
}
